/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.zz.kshc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.drs.dao.DaoService;
import com.xdja.drs.httpClient.bean.HttpResult;
import com.xdja.drs.httpClient.utils.HttpClientUtil;
import com.xdja.drs.model.OutsideDataSource;
import com.xdja.drs.model.OutsideTable;
import com.xdja.drs.service.QueryRequest;
import com.xdja.drs.sql.SqlUtils;
import com.xdja.drs.util.DataOperateType;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BdqjdcQueryWorkFlow
implements WorkFlow {
    private static final Logger logger = LoggerFactory.getLogger(BdqjdcQueryWorkFlow.class);

    public void process(WorkSheet sheet) throws ServiceException {
        if (sheet.getDoType() != DataOperateType.query) {
            logger.error("\u88ab\u76d7\u62a2\u673a\u52a8\u8f66\u6bd4\u5bf9\u67e5\u8be2\u975e\u67e5\u8be2\u63a5\u53e3\uff0c\u8df3\u8fc7");
            return;
        }
        try {
            ArrayList queryResultList;
            JSONObject root;
            String status;
            HttpResult httpResult;
            OutsideTable outsideTable = sheet.getCurrOutTable();
            if (logger.isDebugEnabled()) {
                logger.debug("\u88ab\u76d7\u62a2\u673a\u52a8\u8f66\u6bd4\u5bf9\u67e5\u8be2 OutsideTable:\u3010{}\u3011", (Object)JSON.toJSONString((Object)outsideTable));
            }
            OutsideDataSource outsideDataSource = DaoService.getDataSourceDao().getDS(outsideTable.getOutdsId());
            if (logger.isDebugEnabled()) {
                logger.debug("\u88ab\u76d7\u62a2\u673a\u52a8\u8f66\u6bd4\u5bf9\u67e5\u8be2 OutsideDataSource:\u3010{}\u3011", (Object)JSON.toJSONString((Object)outsideDataSource));
            }
            QueryRequest queryParameters = sheet.getQueryParameters();
            if (logger.isDebugEnabled()) {
                logger.debug("\u88ab\u76d7\u62a2\u673a\u52a8\u8f66\u6bd4\u5bf9\u67e5\u8be2>>>QueryParameters:\u3010{}\u3011", (Object)JSON.toJSONString((Object)queryParameters));
            }
            LinkedHashMap maps = SqlUtils.fetchQueryCondition((String)queryParameters.getCondition());
            String url = outsideDataSource.getUrl();
            final String hphm = (String)maps.get("c_hphm");
            final String accessToken = outsideDataSource.getUsername();
            HashMap<String, String> mapParams = new HashMap<String, String>(){
                {
                    this.put("hphm", hphm);
                }
            };
            String json = JSON.toJSONString((Object)mapParams);
            HashMap<String, String> mapHeader = new HashMap<String, String>(){
                {
                    this.put("accessToken", accessToken);
                }
            };
            if (logger.isDebugEnabled()) {
                logger.debug("\u88ab\u76d7\u62a2\u673a\u52a8\u8f66\u67e5\u8be2\u6bd4\u5bf9>>>url:\u3010{}\u3011,accessToken:\u3010{}\u3011,params:\u3010{}\u3011", new Object[]{url, accessToken, hphm});
            }
            if (!(httpResult = HttpClientUtil.postJson((String)url, (String)json, (Map)mapHeader)).isSucc()) {
                logger.error("\u8c03\u7528\u88ab\u76d7\u62a2\u63a5\u53e3\u5931\u8d25");
                throw new ServiceException("\u8c03\u7528\u88ab\u76d7\u62a2\u63a5\u53e3\u5931\u8d25");
            }
            String result = httpResult.getContent();
            if (logger.isDebugEnabled()) {
                logger.debug("\u88ab\u76d7\u62a2\u673a\u52a8\u8f66\u67e5\u8be2\u6bd4\u5bf9<<<url:\u3010{}\u3011,accessToken:\u3010{}\u3011,params:\u3010{}\u3011,result:\u3010{}\u3011", new Object[]{url, accessToken, hphm, result});
            }
            if ("0".equals(status = (root = JSON.parseObject((String)result)).getString("status"))) {
                JSONArray aryResultJson = root.getJSONArray("result");
                JSONObject resultJSONObject = aryResultJson.getJSONObject(0);
                int resultRecordCount = resultJSONObject.getIntValue("resultRecordCount");
                JSONArray rows = resultJSONObject.getJSONArray("rows");
                JSONArray title = rows.getJSONArray(0);
                queryResultList = new ArrayList();
                HashMap<String, String> data = null;
                for (int i = 0; i < resultRecordCount; ++i) {
                    JSONArray jsonArray = rows.getJSONArray(i + 1);
                    data = new HashMap<String, String>();
                    for (int i1 = 0; i1 < title.size(); ++i1) {
                        data.put(title.getString(i1), jsonArray.getString(i1));
                    }
                    queryResultList.add(data);
                }
            } else {
                logger.error("\u8c03\u7528\u88ab\u76d7\u62a2\u63a5\u53e3\u5931\u8d25\u5931\u8d25");
                throw new ServiceException("\u8c03\u7528\u88ab\u76d7\u62a2\u63a5\u53e3\u5931\u8d25\u5931\u8d25");
            }
            sheet.setQueryResult(queryResultList);
            sheet.setRowTotal((long)queryResultList.size());
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u88ab\u76d7\u62a2\u63a5\u53e3\u5931\u8d25:", (Throwable)e);
            throw new ServiceException("\u8c03\u7528\u88ab\u76d7\u62a2\u63a5\u53e3\u5931\u8d25:" + e.getMessage());
        }
    }

    private String testResult() {
        return "{\n    \"status\": 0,\n    \"memo\": \"\",\n    \"result\": [\n        {\n            \"errorMessage\": \"\",\n            \"isFinished\": true,\n            \"isSuccess\": true,\n            \"messageId\": \"20210625163753f3-a628-ca03c34a6bc2\",\n            \"messageType\": \"MATRIX_RESULT\",\n            \"missionId\": \"20210625163753f3-a628-ca03c34a6bc2\",\n            \"resultRecordCount\": 1,\n            \"rows\": [\n                [\n                    \"SSJDC_JDCHPHM\",\n                    \"SSJDC_PPXH\",\n                    \"SSJDC_CLLXDM_MC\",\n                    \"SSJDC_CLSBDH\",\n                    \"SSJDC_JDCFDJDDJXH\",\n                    \"SSJDC_SFXGJDCFDJDDJH_PDBZ_MC\",\n                    \"SSJDC_JDCCSYS_JDCCSYSDM_MC\",\n                    \"SSJDC_SSJDC_JDCHPZLDM_MC\",\n                    \"SSJDC_CDRQ\",\n                    \"SSJDC_SOYR_XM\",\n                    \"ASJBH\",\n                    \"LARQ\",\n                    \"LADWMC\",\n                    \"ZBR_XM\",\n                    \"ZBR_LXDH\"\n                ],\n                [\n                    \"\u4eacC20924\",\n                    \"\u6851\u5854\u7eb3-\u4e0a\u6d77\u5927\u4f17\u6851\u5854\u7eb3\",\n                    \"\u5c0f\u578b\u8f7f\u8f66\",\n                    \"000451\",\n                    \"181388\",\n                    \"\u5426\",\n                    \"\u767d\",\n                    \"\u5c0f\u578b\u6c7d\u8f66\",\n                    \"1991-11-23 00:00:00\",\n                    \"\u5317\u4eac\u5e02\u536b\u751f\u5c40\u8001\u5e72\u90e8\u5904\",\n                    \"A1101010500001999123043\",\n                    \"1999-12-30 00:00:00\",\n                    \"\u5317\u4eac\u5e02\u516c\u5b89\u5c40\u4e1c\u57ce\u5206\u5c40\",\n                    \"\u51cc\u9f99\",\n                    \"84081500\"\n                ]\n            ],\n            \"tags\": {\n                \"mainResourceId\": \"Postgres_4ac567be7cc34e52ba637098708557e3\",\n                \"resourceId\": \"Postgres_4ac567be7cc34e52ba637098708557e3\"\n            }\n        }\n    ]\n}";
    }
}

