/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.zz.kshc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.drs.dao.DaoService;
import com.xdja.drs.httpClient.bean.HttpResult;
import com.xdja.drs.httpClient.utils.HttpClientUtil;
import com.xdja.drs.model.OutsideDataSource;
import com.xdja.drs.model.OutsideTable;
import com.xdja.drs.service.QueryRequest;
import com.xdja.drs.sql.SqlUtils;
import com.xdja.drs.util.DataOperateType;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZdrybdQueryWorkFlow
implements WorkFlow {
    private static final Logger logger = LoggerFactory.getLogger(ZdrybdQueryWorkFlow.class);

    public void process(WorkSheet sheet) throws ServiceException {
        if (sheet.getDoType() != DataOperateType.query) {
            logger.error("\u91cd\u70b9\u4eba\u5458\u6bd4\u5bf9\u67e5\u8be2\u975e\u67e5\u8be2\u63a5\u53e3\uff0c\u8df3\u8fc7");
            return;
        }
        try {
            ArrayList queryResultList;
            JSONObject root;
            String status;
            HttpResult httpResult;
            OutsideTable outsideTable = sheet.getCurrOutTable();
            if (logger.isDebugEnabled()) {
                logger.debug("\u91cd\u70b9\u4eba\u5458\u6bd4\u5bf9\u67e5\u8be2 OutsideTable:\u3010{}\u3011", (Object)JSON.toJSONString((Object)outsideTable));
            }
            OutsideDataSource outsideDataSource = DaoService.getDataSourceDao().getDS(outsideTable.getOutdsId());
            if (logger.isDebugEnabled()) {
                logger.debug("\u91cd\u70b9\u4eba\u5458\u6bd4\u5bf9\u67e5\u8be2 OutsideDataSource:\u3010{}\u3011", (Object)JSON.toJSONString((Object)outsideDataSource));
            }
            QueryRequest queryParameters = sheet.getQueryParameters();
            if (logger.isDebugEnabled()) {
                logger.debug("\u91cd\u70b9\u4eba\u5458\u6bd4\u5bf9\u67e5\u8be2>>>QueryParameters:\u3010{}\u3011", (Object)JSON.toJSONString((Object)queryParameters));
            }
            LinkedHashMap maps = SqlUtils.fetchQueryCondition((String)queryParameters.getCondition());
            String url = outsideDataSource.getUrl();
            final String sfzh = (String)maps.get("c_sfzh");
            final String accessToken = outsideDataSource.getUsername();
            HashMap<String, String> mapParams = new HashMap<String, String>(){
                {
                    this.put("sfzh", sfzh);
                }
            };
            String json = JSON.toJSONString((Object)mapParams);
            HashMap<String, String> mapHeader = new HashMap<String, String>(){
                {
                    this.put("accessToken", accessToken);
                }
            };
            if (logger.isDebugEnabled()) {
                logger.debug("\u91cd\u70b9\u4eba\u5458\u6bd4\u5bf9>>>url:\u3010{}\u3011,accessToken:\u3010{}\u3011,params:\u3010{}\u3011", new Object[]{url, accessToken, sfzh});
            }
            if (!(httpResult = HttpClientUtil.postJson((String)url, (String)json, (Map)mapHeader)).isSucc()) {
                logger.error("\u91cd\u70b9\u4eba\u5458\u6bd4\u5bf9\u63a5\u53e3\u5931\u8d25");
                throw new ServiceException("\u8c03\u7528\u91cd\u70b9\u4eba\u5458\u6bd4\u5bf9\u5931\u8d25");
            }
            String result = httpResult.getContent();
            if (logger.isDebugEnabled()) {
                logger.debug("\u91cd\u70b9\u4eba\u5458\u6bd4\u5bf9<<<url:\u3010{}\u3011,accessToken:\u3010{}\u3011,params:\u3010{}\u3011,result:\u3010{}\u3011", new Object[]{url, accessToken, sfzh, result});
            }
            if ("0".equals(status = (root = JSON.parseObject((String)result)).getString("status"))) {
                JSONArray aryResultJson = root.getJSONArray("result");
                JSONObject resultJSONObject = aryResultJson.getJSONObject(0);
                int resultRecordCount = resultJSONObject.getIntValue("resultRecordCount");
                JSONArray rows = resultJSONObject.getJSONArray("rows");
                JSONArray title = rows.getJSONArray(0);
                queryResultList = new ArrayList();
                HashMap<String, String> data = null;
                for (int i = 0; i < resultRecordCount; ++i) {
                    JSONArray jsonArray = rows.getJSONArray(i + 1);
                    data = new HashMap<String, String>();
                    for (int i1 = 0; i1 < title.size(); ++i1) {
                        data.put(title.getString(i1), jsonArray.getString(i1));
                    }
                    queryResultList.add(data);
                }
            } else {
                logger.error("\u91cd\u70b9\u4eba\u5458\u6bd4\u5bf9\u5931\u8d25");
                throw new ServiceException("\u91cd\u70b9\u4eba\u5458\u6bd4\u5bf9\u5931\u8d25");
            }
            sheet.setQueryResult(queryResultList);
            sheet.setRowTotal((long)queryResultList.size());
        }
        catch (Exception e) {
            logger.error("\u91cd\u70b9\u4eba\u5458\u6bd4\u5bf9\u63a5\u53e3\u5931\u8d25:", (Throwable)e);
            throw new ServiceException("\u91cd\u70b9\u4eba\u5458\u6bd4\u5bf9\u63a5\u53e3\u5931\u8d25:" + e.getMessage());
        }
    }

    private String testResult() {
        return "{\n    \"status\": 0,\n    \"memo\": \"\",\n    \"result\": [\n        {\n            \"errorMessage\": \"\",\n            \"isFinished\": true,\n            \"isSuccess\": true,\n            \"messageId\": \"2021071414230513-8466-2abf79b3f3e5\",\n            \"messageType\": \"MATRIX_RESULT\",\n            \"missionId\": \"2021071414230513-8466-2abf79b3f3e5\",\n            \"resultRecordCount\": 1,\n            \"rows\": [\n                [\n                    \"SFZH\",\n                    \"XM\",\n                    \"RYLBIDMC\",\n                    \"XB_MC\",\n                    \"JG_MC\",\n                    \"HJDQH_MC\",\n                    \"HJDXZ\",\n                    \"JZDQH_MC\",\n                    \"JZDXZ\",\n                    \"HJDPCSMC\",\n                    \"JZDPCSMC\",\n                    \"LKYY\",\n                    \"LADWMC\",\n                    \"CJR_XM\",\n                    \"CJR_LXDH\",\n                    \"YXX_MC\"\n                ],\n                [\n                    \"410721198202262547\",\n                    \"\u674e\u7389\u82b3\",\n                    \"(\u90e8)\u5728\u9003\",\n                    \"\u5973\",\n                    null,\n                    \"\u6cb3\u5357\u7701\u65b0\u4e61\u53bf\",\n                    \"\u6cb3\u5357\u7701\u65b0\u4e61\u53bf\u5c0f\u5180\u9547\u94c1\u5317\u793e\u533a\uff11\u6392\uff13\u680b\uff15\u53f7\",\n                    \"\u6cb3\u5357\u7701\u65b0\u4e61\u53bf\",\n                    \"\u6cb3\u5357\u7701\u65b0\u4e61\u53bf\u5c0f\u5180\u9547\u79e6\u6751\u8425\u6751\",\n                    null,\n                    null,\n                    \"\u5728\u9003\",\n                    null,\n                    \"\u90d1\u5ef6\u4f1f \u9648\u6811\u4f1f\",\n                    \"18637373808\",\n                    \"\u6709\u6548\"\n                ]\n            ],\n            \"tags\": {\n                \"mainResourceId\": \"OracleDB_5df3677fe4124c988572f4162c967185\",\n                \"resourceId\": \"OracleDB_5df3677fe4124c988572f4162c967185\"\n            }\n        }\n    ]\n}";
    }
}

