/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.service;

import com.xdja.basecode.util.HelpFunction;
import com.xdja.basecode.util.HttpContentProducer;
import com.xdja.basecode.xml.XmlHelper;
import com.xdja.drs.exception.AppThresHoldFailureException;
import com.xdja.drs.exception.RequestParamsNotRightException;
import com.xdja.drs.service.Data;
import com.xdja.drs.service.IDURequest;
import com.xdja.drs.service.IDUResult;
import com.xdja.drs.service.IfaceColumn;
import com.xdja.drs.service.IfaceRow;
import com.xdja.drs.service.IfaceTable;
import com.xdja.drs.service.QueryRequest;
import com.xdja.drs.service.QueryRequestForInvoke;
import com.xdja.drs.service.QueryResult;
import com.xdja.drs.service.UserUnitInfo;
import com.xdja.drs.service.UserUnitInfoForInvoke;
import com.xdja.drs.util.HttpClientPoolUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public final class DrsServiceClient {
    private static final Logger log = Logger.getLogger(DrsServiceClient.class);
    public static final int Http_Connection = 1;
    private static int connectionTimeout = 5;
    private static final Namespace ns = new Namespace("soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
    private static final Namespace ser = new Namespace("ser", "http://service.drs.xdja.com/");
    private static List<Class<?>> classes = new ArrayList();
    private static String wsAddress = null;
    private static int httpExeType = 0;
    private static DrsServiceClient drs = new DrsServiceClient();

    private DrsServiceClient() {
        classes.add(IfaceTable.class);
        classes.add(IfaceRow.class);
        classes.add(IfaceColumn.class);
    }

    public static synchronized DrsServiceClient getInstance(String url, String userID, int exeType) {
        wsAddress = url.endsWith("?wsdl") ? url + "&userid=" + userID : url + "?userid=" + userID;
        httpExeType = exeType;
        log.debug((Object)wsAddress);
        return drs;
    }

    public static synchronized void reInit(String url, String userID, int exeType) {
        wsAddress = url.endsWith("?wsdl") ? url + "&userid=" + userID : url + "?userid=" + userID;
        httpExeType = exeType;
    }

    public String getDS(String localTableName) {
        Document reqDoc = DocumentHelper.createDocument();
        reqDoc.setXMLEncoding("UTF-8");
        Element root = reqDoc.addElement(new QName("Envelope", ns));
        root.add(ser);
        root.addElement(new QName("Header", ns));
        Element body = root.addElement(new QName("Body", ns));
        Element getDs = body.addElement(new QName("getDS", ser));
        getDs.addElement("localTableName").setText(localTableName);
        log.debug((Object)("\u8bf7\u6c42\u5185\u5bb9\uff1a" + reqDoc.asXML()));
        String wsRet = null;
        try {
            wsRet = httpExeType == 1 ? this.executeRequestByConnection(reqDoc.asXML()) : this.executeRequest(reqDoc.asXML());
        }
        catch (Exception e) {
            return "-1 " + e.getMessage();
        }
        Document doc = XmlHelper.getDoc((String)wsRet);
        if (doc == null) {
            return wsRet;
        }
        Element node = doc.getRootElement().element("Body");
        node = (Element)node.elements().get(0);
        Element ret = (Element)node.elements().get(0);
        return ret.getText();
    }

    public QueryResult query(QueryRequest request) {
        Document doc;
        String wsRet;
        ArrayList<Class<UserUnitInfoForInvoke>> cs = new ArrayList<Class<UserUnitInfoForInvoke>>();
        cs.add(UserUnitInfoForInvoke.class);
        request.setCondition("<![CDATA[" + (HelpFunction.isEmpty((String)request.getCondition()) ? "" : request.getCondition()) + "]]>");
        QueryRequestForInvoke queryRequestForInvoke = new QueryRequestForInvoke();
        queryRequestForInvoke.setCondition(request.getCondition());
        queryRequestForInvoke.setDsid(request.getDsid());
        queryRequestForInvoke.setLocalFields(request.getLocalFields());
        queryRequestForInvoke.setLocalTable(request.getLocalTable());
        queryRequestForInvoke.setPageNumber(request.getPageNumber());
        queryRequestForInvoke.setPageSize(request.getPageSize());
        queryRequestForInvoke.setUserId(request.getUserId());
        UserUnitInfo userUnitInfo = request.getUuInfo();
        UserUnitInfoForInvoke userUnitInfoForInvoke = null;
        if (userUnitInfo != null) {
            userUnitInfoForInvoke = new UserUnitInfoForInvoke();
            userUnitInfoForInvoke.setPoliceName(userUnitInfo.getPoliceName());
            userUnitInfoForInvoke.setPoliceSfzh(userUnitInfo.getPoliceSfzh());
            userUnitInfoForInvoke.setUnitCode(userUnitInfo.getUnitCode());
            userUnitInfoForInvoke.setUnitName(userUnitInfo.getUnitName());
            userUnitInfoForInvoke.setZdbs(userUnitInfo.getZdbs());
        }
        queryRequestForInvoke.setUuInfo(userUnitInfoForInvoke);
        QueryResult queryResult = new QueryResult();
        Document reqDoc = DocumentHelper.createDocument();
        reqDoc.setXMLEncoding("UTF-8");
        Element root = reqDoc.addElement(new QName("Envelope", ns));
        root.add(ser);
        root.addElement(new QName("Header", ns));
        Element body = root.addElement(new QName("Body", ns));
        Element getDs = body.addElement(new QName("query", ser));
        StringBuilder addXmlBody = new StringBuilder("");
        HelpFunction.beanToXml((Object)queryRequestForInvoke, cs, (StringBuilder)addXmlBody);
        try {
            getDs.add(DrsServiceClient.generateXmlEle("parameters", addXmlBody));
        }
        catch (DocumentException e1) {
            this.setError(queryResult, e1.getMessage());
            return queryResult;
        }
        log.debug((Object)("\u8bf7\u6c42\u5185\u5bb9\uff1a" + reqDoc.asXML()));
        try {
            wsRet = httpExeType == 1 ? this.executeRequestByConnection(reqDoc.asXML(), request) : this.executeRequest(reqDoc.asXML(), request);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (e instanceof RequestParamsNotRightException) {
                message = "\u65e5\u5fd7\u5ba1\u8ba1\u5f02\u5e38\uff1a\u53c2\u6570\u9a8c\u8bc1\u4e0d\u6b63\u786e\uff01";
            }
            if (e instanceof AppThresHoldFailureException) {
                message = "\u65e5\u5fd7\u5ba1\u8ba1\u5f02\u5e38\uff1a\u8bf7\u6c42\u6b21\u6570\u5df2\u8d85\u8fc7\u9608\u503c\uff01";
            }
            this.setError(queryResult, message);
            return queryResult;
        }
        if (wsRet.indexOf("appThresholdWarn") != -1) {
            queryResult.setAppThresholdWarn("appThresholdWarn");
            wsRet = wsRet.substring(wsRet.indexOf("#") + 1);
        }
        if ((doc = XmlHelper.getDoc((String)wsRet)) == null) {
            this.setError(queryResult, wsRet);
            return queryResult;
        }
        this.parseQueryResult(doc, queryResult);
        return queryResult;
    }

    private String executeRequest(String xml) throws Exception {
        log.debug((Object)"HttpClient\u8c03\u7528\u63a5\u53e3...");
        CloseableHttpClient httpClient = HttpClientPoolUtil.getCloseableHttpClient();
        HttpPost post = new HttpPost(wsAddress);
        HttpClientPoolUtil.config((HttpRequestBase)post);
        post.setHeader("Content-Type", "text/xml;charset=UTF-8");
        post.setHeader("Accept-Encoding", "gzip,deflate");
        post.setHeader("personCode", "gprsserver");
        post.setHeader("appKey", "gprsserver");
        post.setHeader("resServiceCode", "gprsserver");
        post.setHeader("reqTimestamp", System.currentTimeMillis() + "");
        post.setHeader("reqDigest", "gprsserver");
        post.setEntity((HttpEntity)new EntityTemplate((ContentProducer)new HttpContentProducer(xml)));
        HttpEntity entity = null;
        String err = null;
        try {
            String wsRet = null;
            entity = httpClient.execute((HttpUriRequest)post).getEntity();
            InputStream is = entity.getContent();
            byte[] buffer = new byte[262144];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int dataLength = 0;
            while ((dataLength = is.read(buffer)) > -1) {
                baos.write(buffer, 0, dataLength);
            }
            wsRet = new String(baos.toByteArray(), "UTF-8");
            baos = null;
            log.debug((Object)("\u63a5\u53e3\u8fd4\u56de\uff1a" + wsRet));
            String string = wsRet;
            return string;
        }
        catch (ClientProtocolException e) {
            err = "\u5ba2\u6237\u7aef\u8bbf\u95ee\u534f\u8bae\u9519\u8bef\uff1a" + e.getMessage();
            throw new Exception(err);
        }
        catch (IOException e) {
            err = "\u7f51\u7edc\u8bbf\u95ee\u5f02\u5e38\uff1a" + e.getMessage() + "\uff0c\u5f53\u524d\u670d\u52a1\u4e0d\u53ef\u7528";
            throw new Exception(err);
        }
        catch (Exception e) {
            err = "\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage();
            throw new Exception(err);
        }
        finally {
            try {
                if (entity != null) {
                    EntityUtils.consumeQuietly((HttpEntity)entity);
                }
                post.releaseConnection();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String executeRequest(String xml, QueryRequest queryRequest) throws Exception {
        String string;
        log.debug((Object)"HttpClient\u8c03\u7528\u63a5\u53e3...");
        CloseableHttpClient httpClient = HttpClientPoolUtil.getCloseableHttpClient();
        HttpPost post = new HttpPost(wsAddress);
        HttpClientPoolUtil.config((HttpRequestBase)post);
        post.setHeader("Content-Type", "text/xml;charset=UTF-8");
        post.setHeader("Accept-Encoding", "gzip,deflate");
        long currentTimeMills = System.currentTimeMillis();
        post.setHeader("personCode", StringUtils.isBlank((String)queryRequest.getUuInfo().getCode()) ? "gprsserver" : queryRequest.getUuInfo().getCode());
        post.setHeader("appKey", StringUtils.isBlank((String)queryRequest.getAppKey()) ? "gprsserver" : queryRequest.getAppKey());
        post.setHeader("resServiceCode", StringUtils.isBlank((String)queryRequest.getResServiceCode()) ? "gprsserver" : queryRequest.getResServiceCode());
        post.setHeader("reqTimestamp", currentTimeMills + "");
        post.setHeader("reqDigest", StringUtils.isBlank((String)queryRequest.getReqDigest()) ? "" : queryRequest.getReqDigest());
        post.setEntity((HttpEntity)new EntityTemplate((ContentProducer)new HttpContentProducer(xml)));
        HttpResponse httpResponse = null;
        HttpEntity entity = null;
        String err = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)post);
            int responseCode = httpResponse.getStatusLine().getStatusCode();
            Header[] headers = httpResponse.getHeaders("failureReason");
            String failureReason = "";
            if (headers != null && headers.length > 0) {
                failureReason = headers[0].getValue();
            }
            if (responseCode == 403) {
                log.debug((Object)("failureReason:" + failureReason));
                if ("appSecureFailure".equalsIgnoreCase(failureReason)) {
                    throw new RequestParamsNotRightException();
                }
                if ("appThresholdFailure".equalsIgnoreCase(failureReason)) {
                    throw new AppThresHoldFailureException();
                }
            }
            String wsRet = null;
            entity = httpResponse.getEntity();
            InputStream is = entity.getContent();
            byte[] buffer = new byte[262144];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int dataLength = 0;
            while ((dataLength = is.read(buffer)) > -1) {
                baos.write(buffer, 0, dataLength);
            }
            wsRet = new String(baos.toByteArray(), "UTF-8");
            baos = null;
            if ("appThresholdWarn".equalsIgnoreCase(failureReason)) {
                wsRet = failureReason + "#" + wsRet;
            }
            log.debug((Object)("\u63a5\u53e3\u8fd4\u56de\uff1a" + wsRet));
            string = wsRet;
        }
        catch (ClientProtocolException e) {
            try {
                err = "\u5ba2\u6237\u7aef\u8bbf\u95ee\u534f\u8bae\u9519\u8bef\uff1a" + e.getMessage();
                throw new Exception(err);
                catch (IOException e2) {
                    err = "\u7f51\u7edc\u8bbf\u95ee\u5f02\u5e38\uff1a" + e2.getMessage() + "\uff0c\u5f53\u524d\u670d\u52a1\u4e0d\u53ef\u7528";
                    throw new Exception(err);
                }
                catch (Exception e3) {
                    if (e3 instanceof RequestParamsNotRightException) {
                        throw new RequestParamsNotRightException();
                    }
                    if (e3 instanceof AppThresHoldFailureException) {
                        throw new AppThresHoldFailureException();
                    }
                    err = "\u67e5\u8be2\u5931\u8d25\uff1a" + e3.getMessage();
                    throw new Exception(err, e3);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (entity != null) {
                        EntityUtils.consumeQuietly(entity);
                    }
                    post.releaseConnection();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (entity != null) {
                EntityUtils.consumeQuietly((HttpEntity)entity);
            }
            post.releaseConnection();
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private String executeRequestByConnection(String xml) throws Exception {
        log.debug((Object)"HttpUrlConnection\u8c03\u7528\u63a5\u53e3...");
        String wsRet = null;
        URL url = null;
        HttpURLConnection http = null;
        try {
            url = new URL(wsAddress);
            http = (HttpURLConnection)url.openConnection();
            if (http == null) {
                throw new Exception("\u83b7\u53d6\u94fe\u63a5\u5931\u8d25");
            }
            http.setConnectTimeout(connectionTimeout * 1000);
            http.setReadTimeout(connectionTimeout * 1000);
            http.setRequestMethod("POST");
            http.setRequestProperty("content-type", "text/xml;charset=utf-8");
            http.setRequestProperty("personCode", "gprsserver");
            http.setRequestProperty("appKey", "gprsserver");
            http.setRequestProperty("resServiceCode", "gprsserver");
            http.setRequestProperty("reqTimestamp", System.currentTimeMillis() + "");
            http.setRequestProperty("reqDigest", "gprsserver");
            http.setDoOutput(true);
            http.connect();
            byte[] xmlByte = xml.getBytes("UTF-8");
            BufferedOutputStream output = new BufferedOutputStream(http.getOutputStream());
            output.write(xmlByte);
            output.flush();
            output.close();
            output = null;
            BufferedInputStream input = new BufferedInputStream(http.getInputStream());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int num = 0;
            while ((num = input.read(buf)) != -1) {
                baos.write(buf, 0, num);
            }
            input.close();
            input = null;
            wsRet = new String(baos.toByteArray(), "utf-8");
            log.debug((Object)("\u63a5\u53e3\u8fd4\u56de\uff1a" + wsRet));
            http.disconnect();
            return wsRet;
        }
        catch (Exception e) {
            throw new Exception("\u8bf7\u6c42HTTP\u51fa\u9519\uff1a" + e.getMessage());
        }
    }

    private String executeRequestByConnection(String xml, QueryRequest queryRequest) throws Exception {
        log.debug((Object)"HttpUrlConnection\u8c03\u7528\u63a5\u53e3...");
        String wsRet = null;
        URL url = null;
        HttpURLConnection http = null;
        long currentTimeMills = System.currentTimeMillis();
        try {
            url = new URL(wsAddress);
            http = (HttpURLConnection)url.openConnection();
            if (http == null) {
                throw new Exception("\u83b7\u53d6\u94fe\u63a5\u5931\u8d25");
            }
            http.setRequestProperty("personCode", StringUtils.isBlank((String)queryRequest.getUuInfo().getCode()) ? "gprsserver" : queryRequest.getUuInfo().getCode());
            http.setRequestProperty("appKey", StringUtils.isBlank((String)queryRequest.getAppKey()) ? "gprsserver" : queryRequest.getAppKey());
            http.setRequestProperty("resServiceCode", StringUtils.isBlank((String)queryRequest.getResServiceCode()) ? "gprsserver" : queryRequest.getResServiceCode());
            http.setRequestProperty("reqTimestamp", currentTimeMills + "");
            http.setRequestProperty("reqDigest", StringUtils.isBlank((String)queryRequest.getReqDigest()) ? "gprsserver" : queryRequest.getReqDigest());
            http.setConnectTimeout(connectionTimeout * 1000);
            http.setReadTimeout(connectionTimeout * 1000);
            http.setRequestMethod("POST");
            http.setRequestProperty("content-type", "text/xml;charset=utf-8");
            http.setDoOutput(true);
            http.connect();
            byte[] xmlByte = xml.getBytes("UTF-8");
            BufferedOutputStream output = new BufferedOutputStream(http.getOutputStream());
            output.write(xmlByte);
            output.flush();
            output.close();
            output = null;
            int responseCode = http.getResponseCode();
            String failureReason = http.getHeaderField("failureReason");
            if (responseCode == 403) {
                log.debug((Object)("failureReason:" + failureReason));
                if ("appSecureFailure".equalsIgnoreCase(failureReason)) {
                    throw new RequestParamsNotRightException();
                }
                if ("appThresholdFailure".equalsIgnoreCase(failureReason)) {
                    throw new AppThresHoldFailureException();
                }
            }
            BufferedInputStream input = new BufferedInputStream(http.getInputStream());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int num = 0;
            while ((num = input.read(buf)) != -1) {
                baos.write(buf, 0, num);
            }
            input.close();
            input = null;
            wsRet = new String(baos.toByteArray(), "utf-8");
            if ("appThresholdWarn".equalsIgnoreCase(failureReason)) {
                wsRet = failureReason + "#" + wsRet;
            }
            log.debug((Object)("\u63a5\u53e3\u8fd4\u56de\uff1a" + wsRet));
            http.disconnect();
            return wsRet;
        }
        catch (Exception e) {
            if (e instanceof RequestParamsNotRightException) {
                throw new RequestParamsNotRightException();
            }
            if (e instanceof AppThresHoldFailureException) {
                throw new AppThresHoldFailureException();
            }
            throw new Exception("\u8bf7\u6c42HTTP\u51fa\u9519\uff1a" + e.getMessage(), e);
        }
    }

    public IDUResult executeIDU(IDURequest request) {
        String wsRet;
        IDUResult iduResult = new IDUResult();
        Document reqDoc = DocumentHelper.createDocument();
        reqDoc.setXMLEncoding("UTF-8");
        Element root = reqDoc.addElement(new QName("Envelope", ns));
        root.add(ser);
        root.addElement(new QName("Header", ns));
        Element body = root.addElement(new QName("Body", ns));
        Element getDs = body.addElement(new QName("executeIDU", ser));
        StringBuilder addXmlBody = new StringBuilder("");
        HelpFunction.beanToXml((Object)request, classes, (StringBuilder)addXmlBody);
        try {
            getDs.add(DrsServiceClient.generateXmlEle("iduRequest", addXmlBody));
        }
        catch (DocumentException e1) {
            this.setIDUError(iduResult, e1.getMessage());
            return iduResult;
        }
        log.debug((Object)("\u8bf7\u6c42\u5185\u5bb9\uff1a" + reqDoc.asXML()));
        try {
            wsRet = httpExeType == 1 ? this.executeRequestByConnection(reqDoc.asXML()) : this.executeRequest(reqDoc.asXML());
        }
        catch (Exception e) {
            this.setIDUError(iduResult, e.getMessage());
            return iduResult;
        }
        Document doc = XmlHelper.getDoc((String)wsRet);
        if (doc == null) {
            this.setIDUError(iduResult, wsRet);
            return iduResult;
        }
        this.parseIDUResult(doc, iduResult);
        return iduResult;
    }

    private void parseIDUResult(Document doc, IDUResult iduResult) {
        Element node = doc.getRootElement().element("Body");
        node = (Element)node.elements().get(0);
        Element ret = (Element)node.elements().get(0);
        iduResult.setState(HelpFunction.getInt((String)ret.elementText("state"), (int)1));
        System.out.println(iduResult.getState());
        if (iduResult.getState() > 0) {
            iduResult.setErrMsg(ret.elementText("errMsg"));
        }
    }

    private void parseQueryResult(Document doc, QueryResult queryResult) {
        Element node = doc.getRootElement().element("Body");
        node = (Element)node.elements().get(0);
        Element ret = (Element)node.elements().get(0);
        queryResult.setState(HelpFunction.getInt((String)ret.elementText("state"), (int)1));
        if (queryResult.getState() > 0) {
            queryResult.setErrMsg(ret.elementText("errMsg"));
            return;
        }
        queryResult.setCurrRows(HelpFunction.getInt((String)ret.elementText("currRows"), (int)0));
        queryResult.setRowTotal(HelpFunction.getLong((String)ret.elementText("rowTotal"), (long)0L));
        queryResult.setLocalTable(ret.elementText("localTable"));
        List fieldList = ret.elements("localFields");
        String[] fields = new String[fieldList.size()];
        for (int x = 0; x < fields.length; ++x) {
            fields[x] = ((Element)fieldList.get(x)).getText();
        }
        queryResult.setLocalFields(fields);
        List rowList = ret.elements("rows");
        if (rowList.isEmpty()) {
            return;
        }
        for (Element row : rowList) {
            List items = row.elements("item");
            Data[] columnData = new Data[items.size()];
            for (int y = 0; y < items.size(); ++y) {
                Element item = (Element)items.get(y);
                Data data = new Data();
                data.setValue(item.elementText("value"));
                data.setCode(HelpFunction.getBoolean((String)item.elementText("code"), (boolean)false));
                if (data.isCode()) {
                    data.setCodeValue(item.elementText("codeValue"));
                }
                columnData[y] = data;
            }
            queryResult.getRows().add(columnData);
        }
    }

    private void setError(QueryResult queryResult, String result) {
        log.error((Object)result);
        queryResult.setState(1);
        queryResult.setErrMsg(result);
    }

    private void setIDUError(IDUResult iduResult, String result) {
        log.error((Object)result);
        iduResult.setState(1);
        iduResult.setErrMsg(result);
    }

    public static int getConnectionTimeout() {
        return connectionTimeout;
    }

    public static void setConnectionTimeout(int connectionTimeout) {
        DrsServiceClient.connectionTimeout = connectionTimeout;
    }

    private static Element generateXmlEle(String parentEle, StringBuilder xml) throws DocumentException {
        StringBuilder xmlStr = new StringBuilder("");
        xmlStr.append("<").append(parentEle).append(">");
        xmlStr.append((CharSequence)xml);
        xmlStr.append("</").append(parentEle).append(">");
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(xmlStr.toString()));
        return doc.getRootElement();
    }
}

