/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.service;

import com.xdja.drs.service.Data;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResult
implements Serializable {
    private static final long serialVersionUID = -852250109663342536L;
    private int state;
    private long rowTotal;
    private int currRows;
    private String localTable;
    private String[] localFields;
    private List<Data[]> rows = new ArrayList<Data[]>();
    private String errMsg = null;
    private String appThresholdWarn = null;

    public String getAppThresholdWarn() {
        return this.appThresholdWarn;
    }

    public void setAppThresholdWarn(String appThresholdWarn) {
        this.appThresholdWarn = appThresholdWarn;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public long getRowTotal() {
        return this.rowTotal;
    }

    public void setRowTotal(long rowTotal) {
        this.rowTotal = rowTotal;
    }

    public int getCurrRows() {
        return this.currRows;
    }

    public void setCurrRows(int currRows) {
        this.currRows = currRows;
    }

    public String getLocalTable() {
        return this.localTable;
    }

    public void setLocalTable(String localTable) {
        this.localTable = localTable;
    }

    public String[] getLocalFields() {
        return this.localFields;
    }

    public void setLocalFields(String[] localFields) {
        this.localFields = localFields;
    }

    public List<Data[]> getRows() {
        return this.rows;
    }

    public void setRows(List<Data[]> rows) {
        this.rows = rows;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String toString() {
        return this.toXML();
    }

    public String toXML() {
        if (this.errMsg != null) {
            return this.errMsg;
        }
        Document doc = DocumentHelper.createDocument();
        doc.setXMLEncoding("UTF-8");
        Element root = doc.addElement("RequestAgent");
        root.addElement("Type").setText(this.localTable);
        Element values = root.addElement("Items").addElement("Values");
        Element firstRow = values.addElement("Row");
        if (this.errMsg != null) {
            firstRow.addElement("Data").setText("-1");
            firstRow.addElement("Data").setText(this.errMsg);
        } else {
            firstRow.addElement("Data").setText(String.valueOf(this.rowTotal));
            values.addElement("Row").addElement("Data").setText(String.valueOf(this.currRows));
            if (this.rowTotal > 0L) {
                Element threeRow = values.addElement("Row");
                for (String fName : this.localFields) {
                    threeRow.addElement("Data").setText(fName);
                }
                for (Data[] dataRow : this.rows) {
                    Element row = values.addElement("Row");
                    for (Data data : dataRow) {
                        Element dataEl = row.addElement("Data");
                        dataEl.addAttribute("IsCode", data.isCode() ? "1" : "0");
                        dataEl.addAttribute("CodeValue", data.getCodeValue() == null ? "" : data.getCodeValue());
                        if (data.getValue() == null) continue;
                        dataEl.setText(data.getValue());
                    }
                }
            }
        }
        return doc.asXML();
    }
}

