package com.xdja.emoji.manager;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.text.util.Linkify;
import android.widget.TextView;

import com.xdja.emoji.R;
import com.xdja.emoji.utils.BitmapUtils;
import com.xdja.emoji.utils.ImageCache;
import com.xdja.emoji.view.easemob.EaseEmojicon;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static com.xdja.emoji.utils.BitmapUtils.getImageFromAssets;

public class FaceManager {

    private static final String EMOJI_RES_PATH = "sticker/emotion/";

    public static final String DELETE_KEY = "em_delete_delete_expression";
    public static final String PRAISE = "[emoji_060]";
    public static final Pattern EMOTION_URL = Pattern.compile("\\[(\\S+?)\\]");
//	public static final int NUM_PAGE = 5;// 总共有多少页
//	public static int NUM = 20;// 每页20个表情,还有最后一个删除button

    private Map<String, String> mFaceMap = new LinkedHashMap<String, String>();
    //	private JXClientApplication mApp;
    private ArrayList<String> faceKeys;
    private List<EaseEmojicon> emojiconList;//输入框表情(小)面板专用
    private static FaceManager faceManager;
    private FaceManager() {
    }
    public static FaceManager getInstance() {    //对获取实例的方法进行同步
        if (faceManager == null) {
            synchronized (FaceManager.class) {
                if (faceManager == null)
                    faceManager = new FaceManager();
            }
        }
        return faceManager;
    }

    public Map<String, String> getFaceMap() {
        return mFaceMap;
    }

    public ArrayList<String> getFaceKeys() {
        return faceKeys;
    }

    public void initFaceMap() {
        // 目的：适配会话详情表情面板处理方式
        mFaceMap.put("[emoji_000]", EMOJI_RES_PATH + "emoji_000.png");
        mFaceMap.put("[emoji_001]", EMOJI_RES_PATH + "emoji_001.png");
        mFaceMap.put("[emoji_002]", EMOJI_RES_PATH + "emoji_002.png");
        mFaceMap.put("[emoji_003]", EMOJI_RES_PATH + "emoji_003.png");
        mFaceMap.put("[emoji_004]", EMOJI_RES_PATH + "emoji_004.png");
        mFaceMap.put("[emoji_005]", EMOJI_RES_PATH + "emoji_005.png");
        mFaceMap.put("[emoji_006]", EMOJI_RES_PATH + "emoji_006.png");
        mFaceMap.put("[emoji_007]", EMOJI_RES_PATH + "emoji_007.png");
        mFaceMap.put("[emoji_008]", EMOJI_RES_PATH + "emoji_008.png");
        mFaceMap.put("[emoji_009]", EMOJI_RES_PATH + "emoji_009.png");
        mFaceMap.put("[emoji_010]", EMOJI_RES_PATH + "emoji_010.png");
        mFaceMap.put("[emoji_011]", EMOJI_RES_PATH + "emoji_011.png");
        mFaceMap.put("[emoji_012]", EMOJI_RES_PATH + "emoji_012.png");
        mFaceMap.put("[emoji_013]", EMOJI_RES_PATH + "emoji_013.png");
        mFaceMap.put("[emoji_014]", EMOJI_RES_PATH + "emoji_014.png");
        mFaceMap.put("[emoji_015]", EMOJI_RES_PATH + "emoji_015.png");
        mFaceMap.put("[emoji_016]", EMOJI_RES_PATH + "emoji_016.png");
        mFaceMap.put("[emoji_017]", EMOJI_RES_PATH + "emoji_017.png");
        mFaceMap.put("[emoji_018]", EMOJI_RES_PATH + "emoji_018.png");
        mFaceMap.put("[emoji_019]", EMOJI_RES_PATH + "emoji_019.png");
        mFaceMap.put("[emoji_020]", EMOJI_RES_PATH + "emoji_020.png");
        mFaceMap.put("[emoji_021]", EMOJI_RES_PATH + "emoji_021.png");
        mFaceMap.put("[emoji_022]", EMOJI_RES_PATH + "emoji_022.png");
        mFaceMap.put("[emoji_023]", EMOJI_RES_PATH + "emoji_023.png");
        mFaceMap.put("[emoji_024]", EMOJI_RES_PATH + "emoji_024.png");
        mFaceMap.put("[emoji_025]", EMOJI_RES_PATH + "emoji_025.png");
        mFaceMap.put("[emoji_026]", EMOJI_RES_PATH + "emoji_026.png");
        mFaceMap.put("[emoji_027]", EMOJI_RES_PATH + "emoji_027.png");
        mFaceMap.put("[emoji_028]", EMOJI_RES_PATH + "emoji_028.png");
        mFaceMap.put("[emoji_029]", EMOJI_RES_PATH + "emoji_029.png");
        mFaceMap.put("[emoji_030]", EMOJI_RES_PATH + "emoji_030.png");
        mFaceMap.put("[emoji_031]", EMOJI_RES_PATH + "emoji_031.png");
        mFaceMap.put("[emoji_032]", EMOJI_RES_PATH + "emoji_032.png");
        mFaceMap.put("[emoji_033]", EMOJI_RES_PATH + "emoji_033.png");
        mFaceMap.put("[emoji_034]", EMOJI_RES_PATH + "emoji_034.png");
        mFaceMap.put("[emoji_035]", EMOJI_RES_PATH + "emoji_035.png");
        mFaceMap.put("[emoji_036]", EMOJI_RES_PATH + "emoji_036.png");
        mFaceMap.put("[emoji_037]", EMOJI_RES_PATH + "emoji_037.png");
        mFaceMap.put("[emoji_038]", EMOJI_RES_PATH + "emoji_038.png");
        mFaceMap.put("[emoji_039]", EMOJI_RES_PATH + "emoji_039.png");
        mFaceMap.put("[emoji_040]", EMOJI_RES_PATH + "emoji_040.png");
        mFaceMap.put("[emoji_041]", EMOJI_RES_PATH + "emoji_041.png");
        mFaceMap.put("[emoji_042]", EMOJI_RES_PATH + "emoji_042.png");
        mFaceMap.put("[emoji_043]", EMOJI_RES_PATH + "emoji_043.png");
        mFaceMap.put("[emoji_044]", EMOJI_RES_PATH + "emoji_044.png");
        mFaceMap.put("[emoji_045]", EMOJI_RES_PATH + "emoji_045.png");
        mFaceMap.put("[emoji_046]", EMOJI_RES_PATH + "emoji_046.png");
        mFaceMap.put("[emoji_047]", EMOJI_RES_PATH + "emoji_047.png");
        mFaceMap.put("[emoji_048]", EMOJI_RES_PATH + "emoji_048.png");
        mFaceMap.put("[emoji_049]", EMOJI_RES_PATH + "emoji_049.png");
        mFaceMap.put("[emoji_050]", EMOJI_RES_PATH + "emoji_050.png");
        mFaceMap.put("[emoji_051]", EMOJI_RES_PATH + "emoji_051.png");
        mFaceMap.put("[emoji_052]", EMOJI_RES_PATH + "emoji_052.png");
        mFaceMap.put("[emoji_053]", EMOJI_RES_PATH + "emoji_053.png");
        mFaceMap.put("[emoji_054]", EMOJI_RES_PATH + "emoji_054.png");
        mFaceMap.put("[emoji_055]", EMOJI_RES_PATH + "emoji_055.png");
        mFaceMap.put("[emoji_056]", EMOJI_RES_PATH + "emoji_056.png");
        mFaceMap.put("[emoji_057]", EMOJI_RES_PATH + "emoji_057.png");
        mFaceMap.put("[emoji_058]", EMOJI_RES_PATH + "emoji_058.png");
        mFaceMap.put("[emoji_059]", EMOJI_RES_PATH + "emoji_059.png");
        mFaceMap.put("[emoji_060]", EMOJI_RES_PATH + "emoji_060.png");
        mFaceMap.put("[emoji_061]", EMOJI_RES_PATH + "emoji_061.png");
        mFaceMap.put("[emoji_062]", EMOJI_RES_PATH + "emoji_062.png");
        mFaceMap.put("[emoji_063]", EMOJI_RES_PATH + "emoji_063.png");
        mFaceMap.put("[emoji_064]", EMOJI_RES_PATH + "emoji_064.png");
        mFaceMap.put("[emoji_065]", EMOJI_RES_PATH + "emoji_065.png");
        mFaceMap.put("[emoji_066]", EMOJI_RES_PATH + "emoji_066.png");
        mFaceMap.put("[emoji_067]", EMOJI_RES_PATH + "emoji_067.png");
        mFaceMap.put("[emoji_068]", EMOJI_RES_PATH + "emoji_068.png");
        mFaceMap.put("[emoji_069]", EMOJI_RES_PATH + "emoji_069.png");
        mFaceMap.put("[emoji_070]", EMOJI_RES_PATH + "emoji_070.png");
        mFaceMap.put("[emoji_071]", EMOJI_RES_PATH + "emoji_071.png");

        Set<String> keySet = getFaceMap().keySet();
        faceKeys = new ArrayList<String>();
        faceKeys.addAll(keySet);
    }

    /**
     * DQ 2016-03-09 新版本小表情list
     */
    private List<EaseEmojicon> initEmojiconList() {
        List<EaseEmojicon> emojiconList = new ArrayList<EaseEmojicon>();
        for (String emojiconKeyString : faceKeys) {
            EaseEmojicon emojicon = new EaseEmojicon(
                    mFaceMap.get(emojiconKeyString), emojiconKeyString, EaseEmojicon.Type.NORMAL);
            emojiconList.add(emojicon);
        }
        return emojiconList;
    }

    /**
     * 输入框表情(小)面板专用
     */
    public List<EaseEmojicon> getEmojiconList() {
        if (emojiconList != null) {
            return emojiconList;
        } else {
            emojiconList = initEmojiconList();
            return emojiconList;
        }
    }


    /**
     * 另外一种方法解析表情
     *
     * @param message 传入的需要处理的String
     * @return
     */
    public CharSequence convertNormalStringToSpannableString(Context mContext,
                                                             String message) {
        if (TextUtils.isEmpty(message)) return "";
        String hackTxt;
        if (message.startsWith("[") && message.endsWith("]")) {
//			hackTxt = message + " ";
            hackTxt = message;
        } else {
            hackTxt = message;
        }
        SpannableString value = SpannableString.valueOf(hackTxt);

        Matcher localMatcher = EMOTION_URL.matcher(value);
        while (localMatcher.find()) {
            String str2 = localMatcher.group(0);
            int k = localMatcher.start();
            int m = localMatcher.end();
            if (m - k < 12) {
                if (getFaceMap().containsKey(str2)) {
                    ImageCache imageCache = ImageCache.getInstance();
                    Bitmap newBitmap = null;
                    if (imageCache.get(str2) != null) {
                        newBitmap = imageCache.get(str2);
                    } else {
                        String emojiResPath = getFaceMap().get(str2);

                        Bitmap bitmap = getImageFromAssets(mContext, emojiResPath);

                        int edittext_emojicon_size = (int) mContext.getResources().getDimension(R.dimen.edittext_emojicon_size);

                        if (bitmap != null) {
                            int rawHeigh = bitmap.getHeight();
                            int rawWidth = bitmap.getHeight();
                            int newHeight = edittext_emojicon_size;
                            int newWidth = edittext_emojicon_size;
                            // 计算缩放因子
                            float heightScale = ((float) newHeight) / rawHeigh;
                            float widthScale = ((float) newWidth) / rawWidth;
                            // 新建立矩阵
                            Matrix matrix = new Matrix();
                            matrix.postScale(heightScale, widthScale);
                            newBitmap = Bitmap.createBitmap(bitmap, 0, 0,
                                    rawWidth, rawHeigh, matrix, true);
                            imageCache.put(str2, newBitmap);
                            bitmap.recycle();
                        }
                    }

                    ImageSpan imageSpan = new ImageSpan(mContext, newBitmap);
                    value.setSpan(imageSpan, k, m, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                }
            }
        }
        return value;
    }
}
