package com.xdja.emoji.view;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.Toast;

import com.xdja.emoji.R;
import com.xdja.widget.emoji.EmojiconEditText;
import com.xdja.widget.emoji.EmojiconHandler;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 计算当前字数的 EditText
 *
 * @author Administrator
 */
public class InputControlEditText extends EmojiconEditText {

    private int maxLength = 2000;
    public InputLengthHintListener mInputLengthHintListener;
    public GetInputLengthListener mGetInputLengthListener;
    public TextChangedListener mTextChangedListener;
    private MyWatcher mWatcher;
    private Pattern emojiPattern = Pattern.compile(EmojiconHandler.EMOJI_CUSTOM_REGEX);

    public InputControlEditText(Context context, AttributeSet attrs,
                                int defStyle) {

        super(context, attrs, defStyle);
    }

    public InputControlEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public InputControlEditText(Context context) {
        super(context);
    }


    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public interface InputLengthHintListener {
        void onOverFlowHint();
    }

    public void setOnMaxInputListener(int maxInputLength,
                                      InputLengthHintListener Listener) {
        this.maxLength = maxInputLength;
        mInputLengthHintListener = Listener;

        if (mWatcher == null) {
            mWatcher = new MyWatcher();
        }

        addTextChangedListener(mWatcher);
    }

    public interface GetInputLengthListener {
        void getInputLength(long length);
    }

    public void setOnGetInputLengthListener(GetInputLengthListener listener) {
        mGetInputLengthListener = listener;
        if (mWatcher == null) {
            mWatcher = new MyWatcher();
        }
        addTextChangedListener(mWatcher);
    }

    /**
     * add by wanjing 评论字数限制
     */
    public interface TextChangedListener {
        void textChanged(CharSequence s);

        void afterTextChanged(Editable editable);
    }

    public void setTextChangedListener(TextChangedListener listener) {
        this.mTextChangedListener = listener;
    }

    /**
     * end add
     */

    private class MyWatcher implements TextWatcher {
        private long startBackSpaceTime = 0;

        @Override
        public void beforeTextChanged(CharSequence s, int start, int count,
                                      int after) {  //在s中从start开始的count个字符即将被after个字符替换
        }

        @Override
        public void onTextChanged(CharSequence s, int start, int before,
                                  int count) {  //在s中从start开始的before个字符刚刚被count个字符替换
            if (mTextChangedListener != null) {
                mTextChangedListener.textChanged(s);
            }
        }

        private long getTextLength() {
            String tempStr = getText().toString();
            Matcher emojiCustomMatcher = emojiPattern.matcher(tempStr);
            List<CharSequence> emojis = new ArrayList<>();
            while (emojiCustomMatcher.find()) {
                String emojiCustomText = emojiCustomMatcher.group(0);
                emojis.add(emojiCustomText);
                tempStr = tempStr.replace(emojiCustomText, "");
            }
            return tempStr.length() + emojis.size();
        }


        @Override
        public void afterTextChanged(Editable s) {
            long textLength = getTextLength();
            if (mTextChangedListener != null) {
                mTextChangedListener.afterTextChanged(s);
            }
            if (mGetInputLengthListener != null) {
                mGetInputLengthListener.getInputLength(getTextLength());
            }
            //如果超出了输入的最大长度，则删除
            if (textLength > maxLength) {
                if (System.currentTimeMillis() - startBackSpaceTime > 100) {
                    if (mInputLengthHintListener != null) {
                        mInputLengthHintListener.onOverFlowHint();
                    }
                }
                startBackSpaceTime = System.currentTimeMillis();
                onBackSpace();
                return;
            }
            startBackSpaceTime = 0;
        }
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS
                || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS
                || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A
                || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B
                || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION
                || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS
                || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public void onOverFlowHint() {

        Toast.makeText(getContext(),
                getResources().getString(R.string.add_text_over_hint, maxLength + ""), Toast.LENGTH_SHORT).show();
        AnimationYoYo.shakeView(this);
    }

}
