package com.xdja.emoji.view.easemob;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.xdja.emoji.R;
import com.xdja.emoji.manager.FaceManager;

import java.util.List;

import static com.xdja.emoji.utils.BitmapUtils.getImageFromAssets;

public class EmojiconGridAdapter extends ArrayAdapter<EaseEmojicon> {

    private EaseEmojicon.Type emojiconType;
    private LayoutInflater inflater;
    private Context mContext;

    public EmojiconGridAdapter(Context context, int textViewResourceId, List<EaseEmojicon> objects, EaseEmojicon.Type emojiconType) {
        super(context, textViewResourceId, objects);
        this.mContext = context;
        this.emojiconType = emojiconType;
        this.inflater = LayoutInflater.from(context);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            if (emojiconType == EaseEmojicon.Type.BIG_EXPRESSION) {
                convertView = View.inflate(getContext(), R.layout.ease_row_big_expression, null);
            } else {
                convertView = inflater.inflate(R.layout.ease_row_expression, parent, false);
            }
        }

        ImageView imageView = convertView.findViewById(R.id.iv_expression);
        TextView textView = convertView.findViewById(R.id.tv_name);
        EaseEmojicon emojicon = getItem(position);
        if (textView != null && emojicon.getName() != null) {
            textView.setText(emojicon.getName());
        }
        if (FaceManager.DELETE_KEY.equals(emojicon.getEmojiText())) {
            imageView.setImageResource(R.drawable.emotion_del_selector);
        } else {
            if (!TextUtils.isEmpty(emojicon.getEmojiResPath())) {

                Bitmap emojiBitmap = getImageFromAssets(mContext, emojicon.getEmojiResPath());
                imageView.setImageBitmap(emojiBitmap);
            } else if (emojicon.getIconPath() != null) {
                Glide.with(getContext())
                        .load(emojicon.getIconPath())
                        .placeholder(R.drawable.ease_default_expression)
                        .into(imageView);
            }
        }


        return convertView;
    }

}
