package com.xdja.widget.emoji;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.util.ArrayMap;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hieu Rocker (rockerhieu@gmail.com)
 */
public class EmojiconHandler {

    private ArrayMap<CharSequence, String> sEmojisCustomMap = null;
    private static final String EMOJI_RES_PATH = "sticker/emotion/";

    private EmojiconHandler() {
        sEmojisCustomMap = new ArrayMap<>();
        sEmojisCustomMap.put("[emoji_000]", EMOJI_RES_PATH + "emoji_000.png");
        sEmojisCustomMap.put("[emoji_001]", EMOJI_RES_PATH + "emoji_001.png");
        sEmojisCustomMap.put("[emoji_002]", EMOJI_RES_PATH + "emoji_002.png");
        sEmojisCustomMap.put("[emoji_003]", EMOJI_RES_PATH + "emoji_003.png");
        sEmojisCustomMap.put("[emoji_004]", EMOJI_RES_PATH + "emoji_004.png");
        sEmojisCustomMap.put("[emoji_005]", EMOJI_RES_PATH + "emoji_005.png");
        sEmojisCustomMap.put("[emoji_006]", EMOJI_RES_PATH + "emoji_006.png");
        sEmojisCustomMap.put("[emoji_007]", EMOJI_RES_PATH + "emoji_007.png");
        sEmojisCustomMap.put("[emoji_008]", EMOJI_RES_PATH + "emoji_008.png");
        sEmojisCustomMap.put("[emoji_009]", EMOJI_RES_PATH + "emoji_009.png");
        sEmojisCustomMap.put("[emoji_010]", EMOJI_RES_PATH + "emoji_010.png");
        sEmojisCustomMap.put("[emoji_011]", EMOJI_RES_PATH + "emoji_011.png");
        sEmojisCustomMap.put("[emoji_012]", EMOJI_RES_PATH + "emoji_012.png");
        sEmojisCustomMap.put("[emoji_013]", EMOJI_RES_PATH + "emoji_013.png");
        sEmojisCustomMap.put("[emoji_014]", EMOJI_RES_PATH + "emoji_014.png");
        sEmojisCustomMap.put("[emoji_015]", EMOJI_RES_PATH + "emoji_015.png");
        sEmojisCustomMap.put("[emoji_016]", EMOJI_RES_PATH + "emoji_016.png");
        sEmojisCustomMap.put("[emoji_017]", EMOJI_RES_PATH + "emoji_017.png");
        sEmojisCustomMap.put("[emoji_018]", EMOJI_RES_PATH + "emoji_018.png");
        sEmojisCustomMap.put("[emoji_019]", EMOJI_RES_PATH + "emoji_019.png");
        sEmojisCustomMap.put("[emoji_020]", EMOJI_RES_PATH + "emoji_020.png");
        sEmojisCustomMap.put("[emoji_021]", EMOJI_RES_PATH + "emoji_021.png");
        sEmojisCustomMap.put("[emoji_022]", EMOJI_RES_PATH + "emoji_022.png");
        sEmojisCustomMap.put("[emoji_023]", EMOJI_RES_PATH + "emoji_023.png");
        sEmojisCustomMap.put("[emoji_024]", EMOJI_RES_PATH + "emoji_024.png");
        sEmojisCustomMap.put("[emoji_025]", EMOJI_RES_PATH + "emoji_025.png");
        sEmojisCustomMap.put("[emoji_026]", EMOJI_RES_PATH + "emoji_026.png");
        sEmojisCustomMap.put("[emoji_027]", EMOJI_RES_PATH + "emoji_027.png");
        sEmojisCustomMap.put("[emoji_028]", EMOJI_RES_PATH + "emoji_028.png");
        sEmojisCustomMap.put("[emoji_029]", EMOJI_RES_PATH + "emoji_029.png");
        sEmojisCustomMap.put("[emoji_030]", EMOJI_RES_PATH + "emoji_030.png");
        sEmojisCustomMap.put("[emoji_031]", EMOJI_RES_PATH + "emoji_031.png");
        sEmojisCustomMap.put("[emoji_032]", EMOJI_RES_PATH + "emoji_032.png");
        sEmojisCustomMap.put("[emoji_033]", EMOJI_RES_PATH + "emoji_033.png");
        sEmojisCustomMap.put("[emoji_034]", EMOJI_RES_PATH + "emoji_034.png");
        sEmojisCustomMap.put("[emoji_035]", EMOJI_RES_PATH + "emoji_035.png");
        sEmojisCustomMap.put("[emoji_036]", EMOJI_RES_PATH + "emoji_036.png");
        sEmojisCustomMap.put("[emoji_037]", EMOJI_RES_PATH + "emoji_037.png");
        sEmojisCustomMap.put("[emoji_038]", EMOJI_RES_PATH + "emoji_038.png");
        sEmojisCustomMap.put("[emoji_039]", EMOJI_RES_PATH + "emoji_039.png");
        sEmojisCustomMap.put("[emoji_040]", EMOJI_RES_PATH + "emoji_040.png");
        sEmojisCustomMap.put("[emoji_041]", EMOJI_RES_PATH + "emoji_041.png");
        sEmojisCustomMap.put("[emoji_042]", EMOJI_RES_PATH + "emoji_042.png");
        sEmojisCustomMap.put("[emoji_043]", EMOJI_RES_PATH + "emoji_043.png");
        sEmojisCustomMap.put("[emoji_044]", EMOJI_RES_PATH + "emoji_044.png");
        sEmojisCustomMap.put("[emoji_045]", EMOJI_RES_PATH + "emoji_045.png");
        sEmojisCustomMap.put("[emoji_046]", EMOJI_RES_PATH + "emoji_046.png");
        sEmojisCustomMap.put("[emoji_047]", EMOJI_RES_PATH + "emoji_047.png");
        sEmojisCustomMap.put("[emoji_048]", EMOJI_RES_PATH + "emoji_048.png");
        sEmojisCustomMap.put("[emoji_049]", EMOJI_RES_PATH + "emoji_049.png");
        sEmojisCustomMap.put("[emoji_050]", EMOJI_RES_PATH + "emoji_050.png");
        sEmojisCustomMap.put("[emoji_051]", EMOJI_RES_PATH + "emoji_051.png");
        sEmojisCustomMap.put("[emoji_052]", EMOJI_RES_PATH + "emoji_052.png");
        sEmojisCustomMap.put("[emoji_053]", EMOJI_RES_PATH + "emoji_053.png");
        sEmojisCustomMap.put("[emoji_054]", EMOJI_RES_PATH + "emoji_054.png");
        sEmojisCustomMap.put("[emoji_055]", EMOJI_RES_PATH + "emoji_055.png");
        sEmojisCustomMap.put("[emoji_056]", EMOJI_RES_PATH + "emoji_056.png");
        sEmojisCustomMap.put("[emoji_057]", EMOJI_RES_PATH + "emoji_057.png");
        sEmojisCustomMap.put("[emoji_058]", EMOJI_RES_PATH + "emoji_058.png");
        sEmojisCustomMap.put("[emoji_059]", EMOJI_RES_PATH + "emoji_059.png");
        sEmojisCustomMap.put("[emoji_060]", EMOJI_RES_PATH + "emoji_060.png");
        sEmojisCustomMap.put("[emoji_061]", EMOJI_RES_PATH + "emoji_061.png");
        sEmojisCustomMap.put("[emoji_062]", EMOJI_RES_PATH + "emoji_062.png");
        sEmojisCustomMap.put("[emoji_063]", EMOJI_RES_PATH + "emoji_063.png");
        sEmojisCustomMap.put("[emoji_064]", EMOJI_RES_PATH + "emoji_064.png");
        sEmojisCustomMap.put("[emoji_065]", EMOJI_RES_PATH + "emoji_065.png");
        sEmojisCustomMap.put("[emoji_066]", EMOJI_RES_PATH + "emoji_066.png");
        sEmojisCustomMap.put("[emoji_067]", EMOJI_RES_PATH + "emoji_067.png");
        sEmojisCustomMap.put("[emoji_068]", EMOJI_RES_PATH + "emoji_068.png");
        sEmojisCustomMap.put("[emoji_069]", EMOJI_RES_PATH + "emoji_069.png");
        sEmojisCustomMap.put("[emoji_070]", EMOJI_RES_PATH + "emoji_070.png");
        sEmojisCustomMap.put("[emoji_071]", EMOJI_RES_PATH + "emoji_071.png");
    }


    public static EmojiconHandler getEmojiconHandler() {
        return EmojiconHandlerHolder.emojiconHandler;
    }

    public static final String EMOJI_CUSTOM_REGEX = "\\[emoji_[0-9]{3}\\]";

    public static class EmojiconHandlerHolder {
        static final EmojiconHandler emojiconHandler = new EmojiconHandler();
    }

    /**
     * Convert emoji characters of the given Spannable to the according emojicon.
     */
    public static void addEmojis(Context context, Spannable text, int emojiSize, int emojiAlignment, int textSize) {
        if (text == null) {
            return;
        }

        Matcher emojiCustomMatcher = Pattern.compile(EMOJI_CUSTOM_REGEX).matcher(text);
        while (emojiCustomMatcher.find()) {
            String emojiCustomText = emojiCustomMatcher.group(0);
            int emojiCustomStart = emojiCustomMatcher.start();
            int emojiCustomEnd = emojiCustomStart + emojiCustomText.length();
            String emojiPath = getCustomEmojiPath(emojiCustomText);
            if (!TextUtils.isEmpty(emojiPath)) {
                text.setSpan(new EmojiconSpan(context, emojiPath, emojiSize, emojiAlignment, textSize), emojiCustomStart, emojiCustomEnd, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            }
        }
    }

    public static SpannableString getEmojiFormatContent(Context context, CharSequence emojiContent, int emojiSize, int emojiAlignment, int textSize) {
        SpannableString spanContent = new SpannableString(emojiContent);
        Matcher emojiCustomMatcher = Pattern.compile(EMOJI_CUSTOM_REGEX).matcher(emojiContent);
        while (emojiCustomMatcher.find()) {
            String emojiCustomText = emojiCustomMatcher.group(0);
            int emojiCustomStart = emojiCustomMatcher.start();
            int emojiCustomEnd = emojiCustomStart + emojiCustomText.length();
            String emojiPath = getCustomEmojiPath(emojiCustomText);
            if (!TextUtils.isEmpty(emojiPath)) {
                spanContent.setSpan(new EmojiconSpan(context, emojiPath, emojiSize, emojiAlignment, textSize), emojiCustomStart, emojiCustomEnd, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            }
        }
        return spanContent;
    }

    private static String getCustomEmojiPath(CharSequence emojiCustomText) {
        String emojiPath = null;
        if (!TextUtils.isEmpty(emojiCustomText)) {
            emojiPath = EmojiconHandler.getEmojiconHandler().sEmojisCustomMap.get(emojiCustomText);
        }

        return emojiPath;
    }

//    private static int getCustomEmojiResource(CharSequence emojiCustomText) {
//        Integer resource = null;
//        if (!TextUtils.isEmpty(emojiCustomText)) {
//            resource = EmojiconHandler.getEmojiconHandler().sEmojisCustomMap.get(emojiCustomText);
//        }
//        return resource == null ? 0 : resource;
//    }

    public static Drawable getDrawableFromAssets(Context context, String emojiPath) {
        Drawable drawable = null;
        InputStream inputStream = null;
        try {
            inputStream = context.getResources().getAssets().open(emojiPath);
            drawable = Drawable.createFromStream(inputStream, null);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return drawable;
    }
}
