package com.xdja.widget.emoji;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.text.style.DynamicDrawableSpan;

import java.lang.ref.WeakReference;

public class EmojiconSpan extends DynamicDrawableSpan {

    private final Context mContext;

    private final int mResourceId;

    private final String mResourcePath;

    private final int mSize;

    private final int mTextSize;

    private int mHeight;

    private int mWidth;

    private int mTop;

    private Drawable mDrawable;

    private WeakReference<Drawable> mDrawableRef;

    public EmojiconSpan(Context context, int resourceId, int size, int alignment, int textSize) {
        this(context, resourceId, null, size, alignment, textSize);
    }

    public EmojiconSpan(Context context, int resourceId, String resourcePath, int size, int alignment, int textSize) {
        super(alignment);
        this.mContext = context;
        this.mResourceId = resourceId;
        this.mResourcePath = resourcePath;
        mWidth = mHeight = mSize = size;
        mTextSize = textSize;
    }

    public EmojiconSpan(Context context, String resourcePath, int size, int alignment, int textSize) {
        this(context, 0, resourcePath, size, alignment, textSize);
    }

    public Drawable getDrawable() {
        if (mDrawable == null) {
            try {
                if (mResourceId > 0) {
                    mDrawable = mContext.getResources().getDrawable(mResourceId);
                } else if (!TextUtils.isEmpty(mResourcePath)) {
                    mDrawable = EmojiconHandler.getDrawableFromAssets(mContext, mResourcePath);
                }
                mHeight = mSize;
                mWidth = mHeight * mDrawable.getIntrinsicWidth() / mDrawable.getIntrinsicHeight();
                mTop = (mTextSize - mHeight) / 2;
                mDrawable.setBounds(0, mTop, mWidth, mTop + mHeight);
            } catch (Exception e) {
                // swallow
            }
        }
        return mDrawable;
    }

    @Override
    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        //super.draw(canvas, text, start, end, x, top, y, bottom, paint);
        canvas.save();
        Drawable b = getCachedDrawable();
        int transY = bottom - b.getBounds().bottom;
        if (mVerticalAlignment == ALIGN_BASELINE) {
            transY = top + ((bottom - top) / 2) - ((b.getBounds().bottom - b.getBounds().top) / 2) - mTop;
        }
        canvas.translate(x, transY);
        b.draw(canvas);
        canvas.restore();
    }

    private Drawable getCachedDrawable() {
        if (mDrawableRef == null || mDrawableRef.get() == null) {
            mDrawableRef = new WeakReference<Drawable>(getDrawable());
        }
        return mDrawableRef.get();
    }
}