/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.eoa.exception;

import com.alibaba.fastjson.JSON;
import com.xdja.eoa.exception.AccountLogoutException;
import com.xdja.eoa.exception.AccountNotExistException;
import com.xdja.eoa.exception.AccountOrPwdErrorException;
import com.xdja.eoa.exception.ChardNullException;
import com.xdja.eoa.exception.CollectException;
import com.xdja.eoa.exception.CompanyBanAppException;
import com.xdja.eoa.exception.CompanyNoAppException;
import com.xdja.eoa.exception.DeviceBindException;
import com.xdja.eoa.exception.ErrorMessage;
import com.xdja.eoa.exception.FilterAccountLogoutException;
import com.xdja.eoa.exception.FilterAccountNotExistException;
import com.xdja.eoa.exception.GroupException;
import com.xdja.eoa.exception.HttpError;
import com.xdja.eoa.exception.LoginUaException;
import com.xdja.eoa.exception.MomentsException;
import com.xdja.eoa.exception.NoControlDeptException;
import com.xdja.eoa.exception.OldAndNewErrorException;
import com.xdja.eoa.exception.OpenException;
import com.xdja.eoa.exception.PunchCardException;
import com.xdja.eoa.exception.PwdErrorException;
import com.xdja.eoa.exception.PwdTryLimitException;
import com.xdja.eoa.exception.QRException;
import com.xdja.eoa.exception.ResultIsNullException;
import com.xdja.eoa.exception.WorkReportIsNullException;
import com.xdja.eoa.exception.WorkReportLimitException;
import com.xdja.eoa.httpbean.ResponseBean;
import com.xdja.framework.validation.interceptor.SpringValidationException;
import com.xdja.framework.validation.validator.ValidationError;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class CommonExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={SpringValidationException.class})
    @ResponseBody
    public Object handleException(SpringValidationException exception, HttpServletResponse resp, HttpServletRequest request) {
        ValidationError error = (ValidationError)exception.getResult().getErrors().get(0);
        String result = error.getErrorMsg();
        String uri = request.getRequestURI().substring(request.getContextPath().length() + 1);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u8bf7\u6c42Url:{}", (Object)uri);
        }
        if (uri.indexOf("api/v") > -1) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp, result);
        }
        ResponseBean responseBean = new ResponseBean();
        responseBean.setFlag(2);
        responseBean.setMessage(result);
        responseBean.setResult(null);
        CommonExceptionHandler.printWrite(JSON.toJSONString((Object)responseBean), resp);
        return null;
    }

    public static void printWrite(String msg, HttpServletResponse response) {
        try {
            response.setContentType("text/html;charset=utf-8");
            PrintWriter pw = response.getWriter();
            pw.write(msg);
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Object handleException(Exception exception, HttpServletResponse resp) {
        this.logger.error("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (Throwable)exception);
        return HttpError.SERVER_INTERNAL_EXCEPTION.handle(resp, "\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    public Object handleException(IllegalArgumentException exception, HttpServletResponse resp) {
        this.logger.warn("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5", (Throwable)exception);
        return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp, exception.getMessage());
    }

    @ExceptionHandler(value={PwdTryLimitException.class})
    @ResponseBody
    public Object handleException(PwdTryLimitException exception, HttpServletResponse resp) {
        this.logger.warn("\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u4e0a\u9650", (Throwable)exception);
        return HttpError.PWD_TRY_LIMIT.handle(resp, exception.getMessage());
    }

    @ExceptionHandler(value={WorkReportLimitException.class})
    @ResponseBody
    public Object handleException(WorkReportLimitException exception, HttpServletResponse resp) {
        this.logger.warn("\u5de5\u4f5c\u6c47\u62a5\u8d85\u8fc7\u4e0a\u9650", (Throwable)exception);
        return HttpError.WORK_REPORT_LIMIT.handle(resp, exception.getMessage());
    }

    @ExceptionHandler(value={AccountLogoutException.class})
    @ResponseBody
    public Object handleException(AccountLogoutException exception, HttpServletResponse resp) {
        this.logger.warn("\u8d26\u6237\u5df2\u6ce8\u9500", (Throwable)exception);
        return HttpError.ACCOUNT_LOGOUT.handle(resp, exception.getMessage());
    }

    @ExceptionHandler(value={ChardNullException.class})
    @ResponseBody
    public Object handleException(ChardNullException exception, HttpServletResponse resp) {
        this.logger.warn("\u82af\u7247\u4e3a\u7a7a", (Throwable)exception);
        return HttpError.CHARD_NULL.handle(resp, exception.getMessage());
    }

    @ExceptionHandler(value={FilterAccountLogoutException.class})
    @ResponseBody
    public Object handleException(FilterAccountLogoutException exception, HttpServletResponse resp) {
        this.logger.warn("\u8d26\u6237\u5df2\u6ce8\u9500", (Throwable)exception);
        return HttpError.FILTER_ACCOUNT_LOGOUT.handle(resp, exception.getMessage());
    }

    @ExceptionHandler(value={FilterAccountNotExistException.class})
    @ResponseBody
    public Object handleException(FilterAccountNotExistException exception, HttpServletResponse resp) {
        this.logger.warn("\u8d26\u6237\u4e0d\u5b58\u5728", (Throwable)exception);
        return HttpError.FILTER_ACCOUNT_NOT_EXIST.handle(resp, exception.getMessage());
    }

    @ExceptionHandler(value={AccountOrPwdErrorException.class})
    @ResponseBody
    public Object handleException(AccountOrPwdErrorException exception, HttpServletResponse resp) {
        this.logger.warn("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef", (Throwable)exception);
        return HttpError.ACCOUNT_OR_PWD_ERROR.handle(resp, exception.getMessage());
    }

    @ExceptionHandler(value={AccountNotExistException.class})
    @ResponseBody
    public Object handleException(AccountNotExistException exception, HttpServletResponse resp) {
        this.logger.warn("\u8d26\u6237\u4e0d\u5b58\u5728", (Throwable)exception);
        return HttpError.ACCOUNT_NOT_EXIST.handle(resp, exception.getMessage());
    }

    @ExceptionHandler(value={ResultIsNullException.class})
    @ResponseBody
    public Object handleException(ResultIsNullException exception, HttpServletResponse resp) {
        this.logger.warn("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a", (Throwable)exception);
        return HttpError.QUERY_RESULT_IS_NULL.handle(resp, exception.getMessage());
    }

    @ExceptionHandler(value={WorkReportIsNullException.class})
    @ResponseBody
    public Object handleException(WorkReportIsNullException exception, HttpServletResponse resp) {
        this.logger.warn("\u5de5\u4f5c\u6c47\u62a5\u7ed3\u679c\u4e3a\u7a7a", (Throwable)exception);
        return HttpError.WORKREPORT_IS_NULL.handle(resp, exception.getMessage());
    }

    @ExceptionHandler(value={OldAndNewErrorException.class})
    @ResponseBody
    public Object handleException(OldAndNewErrorException exception, HttpServletResponse resp) {
        this.logger.warn("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a", (Throwable)exception);
        return HttpError.OLD_AND_NEW_ERROR.handle(resp, exception.getMessage());
    }

    @ExceptionHandler(value={ServletRequestBindingException.class})
    @ResponseBody
    public Object handleException(ServletRequestBindingException exception, HttpServletResponse resp) {
        this.logger.warn("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a", (Throwable)exception);
        return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp, exception.getMessage());
    }

    @ExceptionHandler(value={NoControlDeptException.class})
    @ResponseBody
    public Object handleException(NoControlDeptException exception, HttpServletResponse resp) {
        this.logger.warn("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a", (Throwable)exception);
        return HttpError.NO_CONTROL.handle(resp, exception.getMessage());
    }

    @ExceptionHandler(value={CompanyNoAppException.class})
    @ResponseBody
    public Object handleException(CompanyNoAppException exception, HttpServletResponse resp) {
        this.logger.warn("\u4f01\u4e1a\u672a\u5f00\u901a\u8be5\u4e1a\u52a1", (Throwable)exception);
        return HttpError.COMPANY_NO_APP.handle(resp, exception.getMessage());
    }

    @ExceptionHandler(value={CompanyBanAppException.class})
    @ResponseBody
    public Object handleException(CompanyBanAppException exception, HttpServletResponse resp) {
        this.logger.warn("\u4f01\u4e1a\u5df2\u7981\u7528\u8be5\u4e1a\u52a1", (Throwable)exception);
        return HttpError.COMPANY_BAN_APP.handle(resp, exception.getMessage());
    }

    @ExceptionHandler(value={MomentsException.class})
    @ResponseBody
    public Object handleException(MomentsException exception, HttpServletResponse resp) {
        this.logger.warn("\u5de5\u4f5c\u5708\u5f02\u5e38\uff1a{}", (Throwable)exception);
        ErrorMessage em = new ErrorMessage();
        em.setErrorCode(exception.getErrCode());
        em.setMessage(exception.getMessage());
        em.setStatusCode(exception.getStatusCode());
        resp.setStatus(exception.getStatusCode());
        return em;
    }

    @ExceptionHandler(value={GroupException.class})
    @ResponseBody
    public Object handleException(GroupException exception, HttpServletResponse resp) {
        this.logger.warn("\u7fa4\u804a\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)exception);
        ErrorMessage em = new ErrorMessage();
        em.setErrorCode(exception.getErrCode());
        em.setMessage(exception.getMessage());
        em.setStatusCode(exception.getStatusCode());
        resp.setStatus(exception.getStatusCode());
        return em;
    }

    @ExceptionHandler(value={OpenException.class})
    @ResponseBody
    public Object handleException(OpenException exception, HttpServletResponse resp) {
        this.logger.warn("OA\u5f00\u653e\u5e73\u53f0\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)exception);
        ErrorMessage em = new ErrorMessage();
        em.setErrorCode(exception.getErrCode());
        em.setMessage(exception.getMessage());
        em.setStatusCode(exception.getStatusCode());
        resp.setStatus(exception.getStatusCode());
        return em;
    }

    @ExceptionHandler(value={DeviceBindException.class})
    @ResponseBody
    public Object handleException(DeviceBindException exception, HttpServletResponse resp) {
        this.logger.warn("\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)exception);
        ErrorMessage em = new ErrorMessage();
        em.setErrorCode(exception.getErrCode());
        em.setMessage(exception.getMessage());
        em.setStatusCode(exception.getStatusCode());
        resp.setStatus(exception.getStatusCode());
        return em;
    }

    @ExceptionHandler(value={PwdErrorException.class})
    @ResponseBody
    public Object handleException(PwdErrorException exception, HttpServletResponse resp) {
        this.logger.warn("\u8bbe\u5907\u89e3\u7ed1\uff0c\u5bc6\u7801\u9a8c\u8bc1\u51fa\u9519\uff1a{}", (Throwable)exception);
        ErrorMessage em = new ErrorMessage();
        em.setErrorCode(exception.getErrCode());
        em.setMessage(exception.getMessage());
        em.setStatusCode(exception.getStatusCode());
        resp.setStatus(exception.getStatusCode());
        return em;
    }

    @ExceptionHandler(value={QRException.class})
    @ResponseBody
    public Object handleException(QRException exception, HttpServletResponse resp) {
        this.logger.warn("\u4e8c\u7ef4\u7801\u626b\u63cf\u767b\u5f55\u51fa\u9519\uff1a{}", (Throwable)exception);
        ErrorMessage em = new ErrorMessage();
        em.setErrorCode(exception.getErrCode());
        em.setMessage(exception.getMessage());
        em.setStatusCode(exception.getStatusCode());
        resp.setStatus(exception.getStatusCode());
        return em;
    }

    @ExceptionHandler(value={LoginUaException.class})
    @ResponseBody
    public Object LoginUaException(LoginUaException exception, HttpServletResponse resp) {
        this.logger.warn("\u767b\u5f55\u5f02\u5e38\uff1a", (Throwable)exception);
        ErrorMessage em = new ErrorMessage();
        em.setErrorCode(exception.getErrCode());
        em.setMessage(exception.getMessage());
        em.setStatusCode(exception.getStatusCode());
        resp.setStatus(exception.getStatusCode());
        return em;
    }

    @ExceptionHandler(value={CollectException.class})
    @ResponseBody
    public Object handleException(CollectException exception, HttpServletResponse resp) {
        this.logger.warn("\u6536\u85cf\u5f02\u5e38\uff1a{}", (Throwable)exception);
        ErrorMessage em = new ErrorMessage();
        em.setErrorCode(exception.getErrCode());
        em.setMessage(exception.getMessage());
        em.setStatusCode(exception.getStatusCode());
        resp.setStatus(exception.getStatusCode());
        return em;
    }

    @ExceptionHandler(value={PunchCardException.class})
    @ResponseBody
    public Object PunchCardException(PunchCardException exception, HttpServletResponse resp) {
        this.logger.warn("\u767b\u5f55\u5f02\u5e38\uff1a", (Throwable)exception);
        ErrorMessage em = new ErrorMessage();
        em.setErrorCode(exception.getErrCode());
        em.setMessage(exception.getMessage());
        em.setStatusCode(exception.getStatusCode());
        resp.setStatus(exception.getStatusCode());
        return em;
    }
}

