/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.eoa.mvc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.servlet.mvc.condition.RequestCondition;

public class ApiVesrsionCondition
implements RequestCondition<ApiVesrsionCondition> {
    private static final Pattern VERSION_PREFIX_PATTERN = Pattern.compile("v(\\d+)/");
    private int apiVersion;

    public ApiVesrsionCondition(int apiVersion) {
        this.apiVersion = apiVersion;
    }

    public ApiVesrsionCondition combine(ApiVesrsionCondition other) {
        return new ApiVesrsionCondition(other.getApiVersion());
    }

    public ApiVesrsionCondition getMatchingCondition(HttpServletRequest request) {
        Integer version;
        Matcher m = VERSION_PREFIX_PATTERN.matcher(request.getPathInfo());
        if (m.find() && (version = Integer.valueOf(m.group(1))) >= this.apiVersion) {
            return this;
        }
        return null;
    }

    public int compareTo(ApiVesrsionCondition other, HttpServletRequest request) {
        return other.getApiVersion() - this.apiVersion;
    }

    public int getApiVersion() {
        return this.apiVersion;
    }
}

