/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.eoa.mvc;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseUtils {
    private static final Logger log = LoggerFactory.getLogger(ResponseUtils.class);

    public static void writeUtf8JSON(HttpServletResponse response, String text) {
        response.setContentType("application/json;charset=UTF-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        try {
            response.getWriter().write(text);
            response.getWriter().flush();
            response.getWriter().close();
        }
        catch (IOException e) {
            log.error("\u5411HttpServletResponse\u4e2d\u5199\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    public static void writeUtf8Text(HttpServletResponse response, String text) {
        response.setContentType("text/html;charset=UTF-8");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        response.setHeader("Expires", "0");
        try {
            response.getWriter().write(text);
            response.getWriter().flush();
            response.getWriter().close();
        }
        catch (IOException e) {
            log.error("\u5411HttpServletResponse\u4e2d\u5199\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }
}

