/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.eoa.commonutil;

import android.support.v4.util.LongSparseArray;
import android.text.TextUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ArraysUtils {
    private static final char[] bcdLookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final int MAX_SQL_PARAM_COUNT = 1000;

    public static String bytes2Hex(byte[] b) {
        StringBuilder s = new StringBuilder(b.length * 2);
        for (int n = 0; n < b.length; ++n) {
            s.append(bcdLookup[b[n] >>> 4 & 0xF]);
            s.append(bcdLookup[b[n] & 0xF]);
        }
        return s.toString();
    }

    public static byte[] hex2Bytes(String src) throws NumberFormatException {
        byte[] bytes = new byte[src.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(src.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public static <T> List<List<T>> subListByLimit(List<T> list, int limit) {
        if (ArraysUtils.isListEmpty(list)) {
            return null;
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("subList limit is invalid:" + limit);
        }
        ArrayList<List<T>> wrapList = new ArrayList<List<T>>();
        for (int count = 0; count < list.size(); count += limit) {
            wrapList.add(new ArrayList<T>(list.subList(count, count + limit > list.size() ? list.size() : count + limit)));
        }
        return wrapList;
    }

    public static long[] list2Array(List<Long> list) {
        if (ArraysUtils.isListEmpty(list)) {
            return null;
        }
        long[] res = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = list.get(i);
        }
        return res;
    }

    public static Long[] list2LongArray(List<Long> list) {
        if (ArraysUtils.isListEmpty(list)) {
            return null;
        }
        Long[] res = new Long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = list.get(i);
        }
        return res;
    }

    public static List<Long> array2List(long[] list) {
        if (list.length < 0) {
            return null;
        }
        ArrayList<Long> res = new ArrayList<Long>();
        for (int i = 0; i < list.length; ++i) {
            res.add(list[i]);
        }
        return res;
    }

    public static <T> List<T> array2List(T[] list) {
        if (list.length < 0) {
            return null;
        }
        return Arrays.asList(list);
    }

    public static boolean isListEmpty(Collection collection) {
        return collection == null || collection.size() == 0;
    }

    public static boolean isLongSparseArrayEmpty(LongSparseArray collection) {
        return collection == null || collection.size() == 0;
    }

    public static boolean isMapEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static <T> boolean isArrayEmpty(T[] values) {
        return values == null || values.length <= 0;
    }

    public static String joinerWith(List<Long> list) {
        if (ArraysUtils.isListEmpty(list)) {
            return null;
        }
        String result = "";
        for (Long aLong : list) {
            if (aLong == null) continue;
            result = result + (TextUtils.isEmpty((CharSequence)result) ? String.valueOf(aLong) : "," + aLong);
        }
        return result;
    }

    public static String joinerWith(List<String> list, String separator) {
        if (ArraysUtils.isListEmpty(list)) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (String aLong : list) {
            if (aLong == null) continue;
            result.append(TextUtils.isEmpty((CharSequence)result) ? aLong : separator + aLong);
        }
        return result.toString();
    }

    public static <T> List<T> deepCopy(List<T> src) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(src);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream in = new ObjectInputStream(byteIn);
            List dest = (List)in.readObject();
            return dest;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> boolean isIndexOutOfBounds(int index, List<T> data) {
        if (ArraysUtils.isListEmpty(data)) {
            return false;
        }
        return index >= data.size() || index < 0;
    }
}

