/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.eoa.commonutil;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitMapUtils {
    private static final int COMPRESS_QUALITY = 75;

    public static File compressBitmap2jpg(Context context, Bitmap bitmap, String fileName) {
        File file = new File(context.getExternalCacheDir().getPath() + "/" + fileName);
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        bitmap.compress(Bitmap.CompressFormat.JPEG, 75, (OutputStream)fOut);
        try {
            if (fOut != null) {
                fOut.flush();
                fOut.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static Bitmap drawableToBitamp(Drawable drawable) {
        int w = drawable.getIntrinsicWidth();
        int h = drawable.getIntrinsicHeight();
        Bitmap.Config config = drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, w, h);
        drawable.draw(canvas);
        return bitmap;
    }

    public static byte[] bitmap2Bytes(Bitmap bm) {
        if (bm == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static Bitmap bytes2Bitmap(byte[] placeholderBytes) {
        if (placeholderBytes == null || placeholderBytes.length <= 0) {
            return null;
        }
        return BitmapFactory.decodeByteArray((byte[])placeholderBytes, (int)0, (int)placeholderBytes.length);
    }
}

