/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.eoa.commonutil;

import android.os.Environment;
import com.blankj.utilcode.utils.Utils;
import java.io.File;

public class EoaCacheFileConstant {
    public static final String CACHE_FILE_ROOT_PATH = "xdja";
    public static final String CACHE_FILE_PATH_OA_GLIDE = "OA_Glide";
    public static final String CACHE_FILE_PATH_OA_FILES_DOWNLOADS = "OA_Download";
    public static final String CACHE_FILE_PATH_OA_IM = "OA_Im";

    public static String getRootCacheFilePath() {
        File file;
        String cachePath = null;
        if ("mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable()) {
            Environment.getExternalStorageDirectory();
            File externalCacheDir = Environment.getExternalStorageDirectory();
            if (externalCacheDir != null) {
                cachePath = externalCacheDir.getPath();
            }
        }
        if (cachePath == null) {
            cachePath = Utils.getContext().getCacheDir().getPath();
        }
        if (!(file = new File(cachePath + File.separator + CACHE_FILE_ROOT_PATH)).exists()) {
            file.mkdir();
        }
        return file.getAbsolutePath();
    }

    public static String getOAGlideCachePath() {
        String rootCachePath = EoaCacheFileConstant.getRootCacheFilePath();
        File file = new File(rootCachePath + File.separator + CACHE_FILE_PATH_OA_GLIDE);
        if (!file.exists()) {
            file.mkdir();
        }
        return file.getAbsolutePath();
    }

    public static String getOAIMCachePath() {
        String rootCachePath = EoaCacheFileConstant.getRootCacheFilePath();
        File file = new File(rootCachePath + File.separator + CACHE_FILE_PATH_OA_IM);
        if (!file.exists()) {
            file.mkdir();
        }
        return file.getAbsolutePath();
    }

    public static String getOACacheFileDownLoadPath() {
        String oaCachePath = EoaCacheFileConstant.getRootCacheFilePath();
        File file = new File(oaCachePath + File.separator + CACHE_FILE_PATH_OA_FILES_DOWNLOADS);
        if (!file.exists()) {
            file.mkdir();
        }
        return file.getAbsolutePath();
    }
}

