/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.eoa.commonutil;

import android.content.Context;
import android.text.TextUtils;
import com.blankj.utilcode.utils.Utils;
import com.rabbit.blade.data.cache.ConfigCacheImpl;
import com.rabbit.blade.data.persistent.PropertyReader;
import com.xdja.eoa.commonutil.ui.DensityUtils;
import okhttp3.HttpUrl;

public class FileUrlUtils {
    private static final String URL_VERSION = "v1/";
    private static final String TAG = FileUrlUtils.class.getSimpleName();
    private static ConfigCacheImpl configCache;

    public static String getThumbnailUrl(String url, int longSideLength) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        try {
            HttpUrl httpUrl = HttpUrl.parse((String)url);
            String fileid = httpUrl.queryParameter("fileid");
            fileid = fileid + "_" + longSideLength + "x" + longSideLength + ".jpg";
            return httpUrl.newBuilder().removeAllQueryParameters("fileid").addQueryParameter("fileid", fileid).build().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return url;
        }
    }

    public static String getVideoThumbnailUrl(String url, int widthPx) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        try {
            HttpUrl httpUrl = HttpUrl.parse((String)url);
            String fileid = httpUrl.queryParameter("fileid");
            fileid = fileid + "_1x" + widthPx + ".jpg";
            return httpUrl.newBuilder().removeAllQueryParameters("fileid").addQueryParameter("fileid", fileid).build().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return url;
        }
    }

    public static String getRealFileUrl(Context context, String url) {
        if (TextUtils.isEmpty((CharSequence)url) || context == null) {
            return url;
        }
        if (url.startsWith("https") || url.startsWith("http")) {
            return url;
        }
        if (configCache == null) {
            configCache = new ConfigCacheImpl(new PropertyReader(context));
        }
        String baseUrl = configCache.getConfig("baseUrl");
        return baseUrl + "eoa-war/api/" + URL_VERSION + url;
    }

    public static String getRealFileUrl(String url) {
        return FileUrlUtils.getRealFileUrl(Utils.getContext(), url);
    }

    public static String getRealThumbnailPx(String url, int longSidePx) {
        return FileUrlUtils.getThumbnailUrl(FileUrlUtils.getRealFileUrl(url), longSidePx);
    }

    public static String getRealThumbnailDp(String url, float longSideDp) {
        return FileUrlUtils.getThumbnailUrl(FileUrlUtils.getRealFileUrl(url), DensityUtils.dip2px(Utils.getContext(), longSideDp));
    }

    public static String getRealVideoThumbnail(String videoUrl, int width) {
        return FileUrlUtils.getVideoThumbnailUrl(FileUrlUtils.getRealFileUrl(videoUrl), width);
    }

    public static String getFileId(String url) {
        try {
            HttpUrl httpUrl = HttpUrl.parse((String)url);
            String fileid = httpUrl.queryParameter("fileid");
            if (!TextUtils.isEmpty((CharSequence)fileid)) {
                return fileid;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    public static String convertFileUrl2Id(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        String temp = "http://www.xdja.com/";
        String fileId = FileUrlUtils.getFileId(temp + url);
        if (fileId.startsWith(temp)) {
            return url;
        }
        return fileId;
    }

    public static String convertFileId2Url(String fileId) {
        if (TextUtils.isEmpty((CharSequence)fileId)) {
            return "";
        }
        return String.format("base/getFile?fileid=%s&perm=1", fileId);
    }
}

