/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.eoa.commonutil;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.eoa.commonutil.exception.EoaException;
import java.io.File;
import java.text.DecimalFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtil {
    static final Pattern PATTERN = Pattern.compile("(.*?)(?:\\((\\d+)\\))?(\\.[^.]*)?");
    public static String[][] MIME_MapTable = new String[][]{{".3gp", "video/3gpp"}, {".apk", "application/vnd.android.package-archive"}, {".asf", "video/x-ms-asf"}, {".avi", "video/x-msvideo"}, {".bin", "application/octet-stream"}, {".bmp", "image/bmp"}, {".c", "text/plain"}, {".class", "application/octet-stream"}, {".conf", "text/plain"}, {".cpp", "text/plain"}, {".doc", "application/msword"}, {".docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document"}, {".xls", "application/vnd.ms-excel"}, {".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"}, {".exe", "application/octet-stream"}, {".gif", "image/gif"}, {".gtar", "application/x-gtar"}, {".gz", "application/x-gzip"}, {".h", "text/plain"}, {".htm", "text/html"}, {".html", "text/html"}, {".jar", "application/java-archive"}, {".java", "text/plain"}, {".jpeg", "image/jpeg"}, {".jpg", "image/jpeg"}, {".js", "application/x-javascript"}, {".log", "text/plain"}, {".m3u", "audio/x-mpegurl"}, {".m4a", "audio/mp4a-latm"}, {".m4b", "audio/mp4a-latm"}, {".m4p", "audio/mp4a-latm"}, {".m4u", "video/vnd.mpegurl"}, {".m4v", "video/x-m4v"}, {".mov", "video/quicktime"}, {".mp2", "audio/x-mpeg"}, {".mp3", "audio/x-mpeg"}, {".mp4", "video/mp4"}, {".mpc", "application/vnd.mpohun.certificate"}, {".mpe", "video/mpeg"}, {".mpeg", "video/mpeg"}, {".mpg", "video/mpeg"}, {".mpg4", "video/mp4"}, {".mpga", "audio/mpeg"}, {".msg", "application/vnd.ms-outlook"}, {".ogg", "audio/ogg"}, {".pdf", "application/pdf"}, {".png", "image/png"}, {".pps", "application/vnd.ms-powerpoint"}, {".ppt", "application/vnd.ms-powerpoint"}, {".pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation"}, {".prop", "text/plain"}, {".rc", "text/plain"}, {".rmvb", "audio/x-pn-realaudio"}, {".rtf", "application/rtf"}, {".sh", "text/plain"}, {".tar", "application/x-tar"}, {".tgz", "application/x-compressed"}, {".txt", "text/plain"}, {".wav", "audio/x-wav"}, {".wma", "audio/x-ms-wma"}, {".wmv", "audio/x-ms-wmv"}, {".wps", "application/vnd.ms-works"}, {".xml", "text/plain"}, {".z", "application/x-compress"}, {".zip", "application/x-zip-compressed"}, {".aac", "audio/aac"}, {".jpe", "image/jpeg"}, {".amr", "audio/amr"}, {".mid", "audio/mid"}, {"", "*/*"}};

    public static String formatFromSize(long size) {
        if (size == 0L) {
            return "0 B";
        }
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = size < 1024L ? df.format((double)size) + " B" : (size < 0x100000L ? df.format((double)size / 1024.0) + " KB" : (size < 0x40000000L ? df.format((double)size / 1048576.0) + " MB" : df.format((double)size / 1.073741824E9) + " GB"));
        return fileSizeString;
    }

    public static void openFileAndHint(Context context, String filePath) throws EoaException {
        try {
            FileUtil.openFile(context, filePath);
        }
        catch (Exception e) {
            throw new EoaException("\u6ca1\u6709\u53ef\u6253\u5f00\u6b64\u6587\u4ef6\u7684\u7a0b\u5e8f");
        }
    }

    public static void openInstalledApp(Context context, String pkgName) throws EoaException {
        block5: {
            try {
                PackageManager packageManager = context.getPackageManager();
                Intent it = packageManager.getLaunchIntentForPackage(pkgName);
                if (it != null) {
                    it.addFlags(0x10000000);
                    context.startActivity(it);
                    break block5;
                }
                PackageManager pm = context.getPackageManager();
                Intent intentQuery = new Intent("android.intent.action.MAIN");
                intentQuery.setPackage(pkgName);
                List resolveInfos = pm.queryIntentActivities(intentQuery, 1);
                String activityName = "";
                for (int i = 0; i < resolveInfos.size(); ++i) {
                    ResolveInfo resolveInfo = (ResolveInfo)resolveInfos.get(i);
                    if (!resolveInfo.activityInfo.packageName.equals(pkgName)) continue;
                    activityName = resolveInfo.activityInfo.name;
                    break;
                }
                if (!TextUtils.isEmpty((CharSequence)activityName)) {
                    Intent intent = new Intent();
                    intent.setClassName(pkgName, activityName);
                    intent.addFlags(0x10000000);
                    context.startActivity(intent);
                    break block5;
                }
                throw new EoaException("\u8be5\u5e94\u7528\u4e0d\u652f\u6301\u6253\u5f00");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new EoaException("\u8be5\u5e94\u7528\u4e0d\u652f\u6301\u6253\u5f00");
            }
        }
    }

    public static boolean isAppInstalled(Context context, String packageName) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            packageInfo = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            packageInfo = null;
        }
        return packageInfo != null;
    }

    private static void grantUriPermission(Context context, Uri fileUri, Intent intent) {
        List resolveInfoList = context.getPackageManager().queryIntentActivities(intent, 65536);
        for (ResolveInfo resolveInfo : resolveInfoList) {
            String packageName = resolveInfo.activityInfo.packageName;
            context.grantUriPermission(packageName, fileUri, 3);
        }
    }

    public static void openFile(Context context, String filePath) throws Exception {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            Log.e((String)"OpenFileUtil", (String)"\u6587\u4ef6\u6253\u5f00\u5931\u8d25 \u8def\u5f84\u4e3a\u7a7a");
            return;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        String mimeType = FileUtil.getMIMEType(new File(filePath));
        if ("*/*".equals(mimeType)) {
            mimeType = FileUtil.getMimeType(filePath);
        }
        File file = new File(filePath);
        if (Build.VERSION.SDK_INT >= 24) {
            Uri data = FileProvider.getUriForFile((Context)context.getApplicationContext(), (String)(context.getPackageName() + ".autoupdate.fileprovider"), (File)file);
            intent.setFlags(2);
            intent.setDataAndType(data, mimeType);
            FileUtil.grantUriPermission(context, data, intent);
        } else {
            intent.setDataAndType(Uri.fromFile((File)file), mimeType);
        }
        context.startActivity(intent);
    }

    public static String getMimeType(String filePath) {
        MediaMetadataRetriever mmr = new MediaMetadataRetriever();
        String mime = "*/*";
        if (filePath != null) {
            try {
                mmr.setDataSource(filePath);
                mime = mmr.extractMetadata(12);
            }
            catch (IllegalStateException e) {
                return mime;
            }
            catch (IllegalArgumentException e) {
                return mime;
            }
            catch (RuntimeException e) {
                return mime;
            }
        }
        return mime;
    }

    public static String getMIMEType(File file) {
        String type = "*/*";
        String fName = file.getName();
        int dotIndex = fName.lastIndexOf(".");
        if (dotIndex < 0) {
            return type;
        }
        String end = fName.substring(dotIndex, fName.length()).toLowerCase();
        if ("".equals(end)) {
            return type;
        }
        for (int i = 0; i < MIME_MapTable.length; ++i) {
            if (!end.equals(MIME_MapTable[i][0])) continue;
            type = MIME_MapTable[i][1];
        }
        return type;
    }

    @NonNull
    public static File getDiskCacheDir(Context context, String uniqueName) {
        File file;
        File externalCacheDir;
        String cachePath = null;
        if (("mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable()) && (externalCacheDir = context.getExternalCacheDir()) != null) {
            cachePath = externalCacheDir.getPath();
        }
        if (cachePath == null) {
            cachePath = context.getCacheDir().getPath();
        }
        if (!(file = new File(cachePath + File.separator + uniqueName)).exists()) {
            file.mkdir();
        }
        return file;
    }

    public static String generateAccessableFileName(@NonNull String dirPath, @NonNull String fileName) {
        String fName = fileName;
        File targetFile = new File(dirPath, fName);
        if (!targetFile.exists()) {
            return fName;
        }
        Matcher m = PATTERN.matcher(fName);
        if (m.matches()) {
            int count;
            String prefix = m.group(1);
            String last = m.group(2);
            String suffix = m.group(3);
            if (suffix == null) {
                suffix = "";
            }
            int n = count = last != null ? Integer.parseInt(last) : 0;
            while ((targetFile = new File(dirPath, fName = prefix + "(" + ++count + ")" + suffix)).exists()) {
            }
        }
        return fName;
    }
}

