/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.eoa.commonutil;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.FloatRange;
import android.support.annotation.RequiresApi;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.regex.Pattern;

public class StatusBarUtil {
    public static int DEFAULT_COLOR = 0;
    public static float DEFAULT_ALPHA = 0.0f;
    public static final int MIN_API = 19;

    public static void immersive(Activity activity) {
        StatusBarUtil.immersive(activity, DEFAULT_COLOR, DEFAULT_ALPHA);
    }

    public static void immersive(Activity activity, int color, @FloatRange(from=0.0, to=1.0) float alpha) {
        StatusBarUtil.immersive(activity.getWindow(), color, alpha);
    }

    public static void immersive(Activity activity, int color) {
        StatusBarUtil.immersive(activity.getWindow(), color, 1.0f);
    }

    public static void immersive(Window window) {
        StatusBarUtil.immersive(window, DEFAULT_COLOR, DEFAULT_ALPHA);
    }

    public static void immersive(Window window, int color) {
        StatusBarUtil.immersive(window, color, 1.0f);
    }

    public static void immersive(Window window, int color, @FloatRange(from=0.0, to=1.0) float alpha) {
        if (Build.VERSION.SDK_INT >= 21) {
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(StatusBarUtil.mixtureColor(color, alpha));
            int systemUiVisibility = window.getDecorView().getSystemUiVisibility();
            systemUiVisibility |= 0x400;
            window.getDecorView().setSystemUiVisibility(systemUiVisibility |= 0x100);
        } else if (Build.VERSION.SDK_INT >= 19) {
            window.addFlags(0x4000000);
            StatusBarUtil.setTranslucentView((ViewGroup)window.getDecorView(), color, alpha);
        } else if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT > 16) {
            int systemUiVisibility = window.getDecorView().getSystemUiVisibility();
            systemUiVisibility |= 0x400;
            window.getDecorView().setSystemUiVisibility(systemUiVisibility |= 0x100);
        }
    }

    public static void darkMode(Activity activity, boolean dark) {
        if (StatusBarUtil.isFlyme4Later()) {
            StatusBarUtil.darkModeForFlyme4(activity.getWindow(), dark);
        } else if (StatusBarUtil.isMIUI6Later()) {
            StatusBarUtil.darkModeForMIUI6(activity.getWindow(), dark);
        } else if (Build.VERSION.SDK_INT >= 23) {
            StatusBarUtil.darkModeForM(activity.getWindow(), dark);
        }
    }

    public static void darkMode(Activity activity) {
        StatusBarUtil.darkMode(activity.getWindow(), DEFAULT_COLOR, DEFAULT_ALPHA);
    }

    public static void darkMode(Activity activity, int color, @FloatRange(from=0.0, to=1.0) float alpha) {
        StatusBarUtil.darkMode(activity.getWindow(), color, alpha);
    }

    public static void darkMode(Window window, int color, @FloatRange(from=0.0, to=1.0) float alpha) {
        if (StatusBarUtil.isFlyme4Later()) {
            StatusBarUtil.darkModeForFlyme4(window, true);
            StatusBarUtil.immersive(window, color, alpha);
        } else if (StatusBarUtil.isMIUI6Later()) {
            StatusBarUtil.darkModeForMIUI6(window, true);
            StatusBarUtil.immersive(window, color, alpha);
        } else if (Build.VERSION.SDK_INT >= 23) {
            StatusBarUtil.darkModeForM(window, true);
            StatusBarUtil.immersive(window, color, alpha);
        } else if (Build.VERSION.SDK_INT >= 19) {
            window.addFlags(0x4000000);
            StatusBarUtil.setTranslucentView((ViewGroup)window.getDecorView(), color, alpha);
        } else {
            StatusBarUtil.immersive(window, color, alpha);
        }
    }

    @RequiresApi(value=23)
    private static void darkModeForM(Window window, boolean dark) {
        int systemUiVisibility = window.getDecorView().getSystemUiVisibility();
        systemUiVisibility = dark ? (systemUiVisibility |= 0x2000) : (systemUiVisibility &= 0xFFFFDFFF);
        window.getDecorView().setSystemUiVisibility(systemUiVisibility);
    }

    public static boolean darkModeForFlyme4(Window window, boolean dark) {
        boolean result = false;
        if (window != null) {
            try {
                WindowManager.LayoutParams e = window.getAttributes();
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(e);
                value = dark ? (value |= bit) : (value &= ~bit);
                meizuFlags.setInt(e, value);
                window.setAttributes(e);
                result = true;
            }
            catch (Exception var8) {
                Log.e((String)"StatusBar", (String)"darkIcon: failed");
            }
        }
        return result;
    }

    public static boolean darkModeForMIUI6(Window window, boolean darkmode) {
        Class<?> clazz = window.getClass();
        try {
            int darkModeFlag = 0;
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            darkModeFlag = field.getInt(layoutParams);
            Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
            extraFlagField.invoke((Object)window, darkmode ? darkModeFlag : 0, darkModeFlag);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isFlyme4Later() {
        return Build.FINGERPRINT.contains("Flyme_OS_4") || Build.VERSION.INCREMENTAL.contains("Flyme_OS_4") || Pattern.compile("Flyme OS [4|5]", 2).matcher(Build.DISPLAY).find();
    }

    public static boolean isMIUI6Later() {
        try {
            Class<?> clz = Class.forName("android.os.SystemProperties");
            Method mtd = clz.getMethod("get", String.class);
            String val = (String)mtd.invoke(null, "ro.miui.ui.version.name");
            val = val.replaceAll("[vV]", "");
            int version = Integer.parseInt(val);
            return version >= 6 && version <= 7;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setPadding(Context context, View view) {
        if (Build.VERSION.SDK_INT >= 19) {
            view.setPadding(view.getPaddingLeft(), view.getPaddingTop() + StatusBarUtil.getStatusBarHeight(context), view.getPaddingRight(), view.getPaddingBottom());
        }
    }

    public static void setPaddingSmart(Context context, View view) {
        if (Build.VERSION.SDK_INT >= 19) {
            ViewGroup.LayoutParams lp = view.getLayoutParams();
            if (lp != null && lp.height > 0) {
                lp.height += StatusBarUtil.getStatusBarHeight(context);
            }
            view.setPadding(view.getPaddingLeft(), view.getPaddingTop() + StatusBarUtil.getStatusBarHeight(context), view.getPaddingRight(), view.getPaddingBottom());
        }
    }

    public static void setHeightAndPadding(Context context, View view) {
        if (Build.VERSION.SDK_INT >= 19) {
            ViewGroup.LayoutParams lp = view.getLayoutParams();
            lp.height += StatusBarUtil.getStatusBarHeight(context);
            view.setPadding(view.getPaddingLeft(), view.getPaddingTop() + StatusBarUtil.getStatusBarHeight(context), view.getPaddingRight(), view.getPaddingBottom());
        }
    }

    public static void setMargin(Context context, View view) {
        if (Build.VERSION.SDK_INT >= 19) {
            ViewGroup.LayoutParams lp = view.getLayoutParams();
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                ((ViewGroup.MarginLayoutParams)lp).topMargin += StatusBarUtil.getStatusBarHeight(context);
            }
            view.setLayoutParams(lp);
        }
    }

    public static void setTranslucentView(ViewGroup container, int color, @FloatRange(from=0.0, to=1.0) float alpha) {
        if (Build.VERSION.SDK_INT >= 19) {
            int mixtureColor = StatusBarUtil.mixtureColor(color, alpha);
            View translucentView = container.findViewById(16908331);
            if (translucentView == null && mixtureColor != 0) {
                translucentView = new View(container.getContext());
                translucentView.setId(16908331);
                ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, StatusBarUtil.getStatusBarHeight(container.getContext()));
                container.addView(translucentView, lp);
            }
            if (translucentView != null) {
                translucentView.setBackgroundColor(mixtureColor);
            }
        }
    }

    public static int mixtureColor(int color, @FloatRange(from=0.0, to=1.0) float alpha) {
        int a = (color & 0xFF000000) == 0 ? 255 : color >>> 24;
        return color & 0xFFFFFF | (int)((float)a * alpha) << 24;
    }

    public static int getStatusBarHeight(Context context) {
        int result = 24;
        int resId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        result = resId > 0 ? context.getResources().getDimensionPixelSize(resId) : (int)TypedValue.applyDimension((int)1, (float)result, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
        return result;
    }
}

