/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.eoa.commonutil.permission;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import com.xm.permissions.OnPermissionResult;
import com.xm.permissions.PermissionUtils;
import com.xm.permissions.PermissionsManager;
import java.util.Arrays;
import java.util.List;

public class PermissionsUtils {
    public static final String[] LAUNCH_PERMISSION = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_PHONE_STATE", "android.permission.READ_SYNC_SETTINGS", "android.permission.WRITE_SYNC_SETTINGS", "android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"};
    public static final String[] TAKEPHOTO_PERMISSION = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"};
    public static final String[] IMAGESELECT_PERMISSION = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
    public static final String[] FILESELECT_PERMISSION = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
    public static final String[] TAKEVIDEO_PERMISSION = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.RECORD_AUDIO", "android.permission.CAMERA"};
    public static final String[] LOCATION_PERMISSION = new String[]{"android.permission.ACCESS_COARSE_LOCATION"};
    public static final String[] RECORD_AUDIO_PERMISSION = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.RECORD_AUDIO"};
    public static final String[] INCOME_CALL_PERMISSION = new String[]{"android.permission.SYSTEM_ALERT_WINDOW"};

    public static boolean havePermission(Context context, String permission2) {
        return PermissionUtils.hasPermission((Context)context, Arrays.asList(permission2));
    }

    public static boolean havePermission(Context context, String ... permission2) {
        return PermissionUtils.hasPermission((Context)context, Arrays.asList(permission2));
    }

    public static boolean havePermission(Context context, List<String> permission2) {
        return PermissionUtils.hasPermission((Context)context, permission2);
    }

    public static boolean havePermissionWithRequest(Activity activity, int requestCode, final OnResultListener onResultListener, String ... permission2) {
        boolean result = PermissionUtils.hasPermission((Context)activity, Arrays.asList(permission2));
        if (result) {
            if (onResultListener != null) {
                onResultListener.onSucceed();
            }
            return true;
        }
        PermissionsUtils.permissionRequest(activity, requestCode, new OnPermissionListener(){

            @Override
            public void onSucceed(int requestCode) {
                if (onResultListener != null) {
                    onResultListener.onSucceed();
                }
            }

            @Override
            public void onFailed(int requestCode) {
                if (onResultListener != null) {
                    onResultListener.onPermissionDenied();
                }
            }
        }, permission2);
        return result;
    }

    public static void goSettingActivity(@NonNull Activity activity, int requestCode) {
        PermissionUtils.goSettingActivity((Activity)activity, (int)requestCode);
    }

    public static void permissionRequest(Activity activity, int requsetCode, OnPermissionListener onPermissionListener, String ... permissions) {
        PermissionsUtils.permissionRequest(activity, requsetCode, onPermissionListener, Arrays.asList(permissions));
    }

    public static void permissionRequest(Activity activity, final int requsetCode, final OnPermissionListener onPermissionListener, List<String> permissionList) {
        String[] permissions = new String[permissionList.size()];
        permissionList.toArray(permissions);
        PermissionsManager permissionsManager = new PermissionsManager(activity);
        permissionsManager.setPermissions(permissions).setOnPermissionResult(new OnPermissionResult(){

            public void onSuccess() {
                if (onPermissionListener != null) {
                    onPermissionListener.onSucceed(requsetCode);
                }
            }

            public void onFailed(boolean onRationale) {
                if (onPermissionListener != null) {
                    onPermissionListener.onFailed(requsetCode);
                }
            }
        }).request();
    }

    public static void request2GoSetting(Activity activity, int requestCode, final OnResultListener onResultListener, String ... permission2) {
        if (!PermissionsUtils.havePermission((Context)activity, permission2)) {
            PermissionsUtils.permissionRequest(activity, requestCode, new OnPermissionListener(){

                @Override
                public void onSucceed(int requestCode) {
                    if (onResultListener != null) {
                        onResultListener.onSucceed();
                    }
                }

                @Override
                public void onFailed(int requestCode) {
                    if (onResultListener != null) {
                        onResultListener.onPermissionDenied();
                    }
                }
            }, permission2);
        } else if (onResultListener != null) {
            onResultListener.onSucceed();
        }
    }

    public static interface OnPermissionListener {
        public void onSucceed(int var1);

        public void onFailed(int var1);
    }

    public static interface OnResultListener {
        public void onSucceed();

        public void onDialogCancel();

        public void onPermissionDenied();
    }

    public static class AbsOnResultListener
    implements OnResultListener {
        @Override
        public void onSucceed() {
        }

        @Override
        public void onDialogCancel() {
        }

        @Override
        public void onPermissionDenied() {
        }
    }
}

