package com.xdja.eoa.commonutil;

import java.io.Serializable;

/**
 *
 * @author hkb
 * @date 2018/3/12 0012
 */

public class Pair<F, S> implements Serializable {
    public final F first;
    public final S second;

    public Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof android.support.v4.util.Pair)) {
            return false;
        } else {
            android.support.v4.util.Pair<?, ?> p = (android.support.v4.util.Pair) o;
            return objectsEqual(p.first, this.first) && objectsEqual(p.second, this.second);
        }
    }

    private static boolean objectsEqual(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    @Override
    public int hashCode() {
        return (this.first == null ? 0 : this.first.hashCode()) ^ (this.second == null ? 0 : this.second.hashCode());
    }

    @Override
    public String toString() {
        return "Pair{" + String.valueOf(this.first) + " " + this.second + "}";
    }

    public static <A, B> Pair<A, B> create(A a, B b) {
        return new Pair(a, b);
    }
}