package com.xdja.eoa.commonwidget.widget.refreshloading;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.jcodecraeer.xrecyclerview.ProgressStyle;
import com.jcodecraeer.xrecyclerview.SimpleViewSwitcher;
import com.jcodecraeer.xrecyclerview.progressindicator.AVLoadingIndicatorView;

/**
 * <b>Description: </b>
 * Created by <a href="mailto:hjl@xdja.com">hjl</a> on 2017/5/9.
 */

public class ArrowRefreshHeader extends BaseRefreshHeader {

    private ImageView mArrowImageView;
    private SimpleViewSwitcher mProgressBar;
    private TextView mStatusTextView;
    private Animation mRotateUpAnim;
    private Animation mRotateDownAnim;

    private static final int ROTATE_ANIM_DURATION = 180;

    public ArrowRefreshHeader(Context context) {
        super(context);
    }

    public ArrowRefreshHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected int getHeaderResId() {
        return com.jcodecraeer.xrecyclerview.R.layout.listview_header;
    }

    public void setProgressStyle(int style) {
        if(style == ProgressStyle.SysProgress){
            mProgressBar.setView(new ProgressBar(getContext(), null, android.R.attr.progressBarStyle));
        }else{
            AVLoadingIndicatorView progressView = new  AVLoadingIndicatorView(this.getContext());
            progressView.setIndicatorColor(0xffB5B5B5);
            progressView.setIndicatorId(style);
            mProgressBar.setView(progressView);
        }
    }

    public void setArrowImageView(int resid){
        mArrowImageView.setImageResource(resid);
    }

    @Override
    protected void onPreReFresh() {

        mArrowImageView.setVisibility(View.VISIBLE);
        mProgressBar.setVisibility(View.INVISIBLE);

        if (getState() == IRefreshHeader.STATE_RELEASE_TO_REFRESH) {
            mArrowImageView.startAnimation(mRotateDownAnim);
        }
        if (getState() == IRefreshHeader.STATE_REFRESHING) {
            mArrowImageView.clearAnimation();
        }
        mStatusTextView.setText(com.jcodecraeer.xrecyclerview.R.string.listview_header_hint_normal);
    }

    @Override
    protected void onRelease2ReFresh() {
        mArrowImageView.setVisibility(View.VISIBLE);
        mProgressBar.setVisibility(View.INVISIBLE);

        if (getState() != IRefreshHeader.STATE_RELEASE_TO_REFRESH) {
            mArrowImageView.clearAnimation();
            mArrowImageView.startAnimation(mRotateUpAnim);
            mStatusTextView.setText(com.jcodecraeer.xrecyclerview.R.string.listview_header_hint_release);
        }
    }

    @Override
    protected void onReFreshing() {
        mArrowImageView.clearAnimation();
        mArrowImageView.setVisibility(View.INVISIBLE);
        mProgressBar.setVisibility(View.VISIBLE);

        mStatusTextView.setText(com.jcodecraeer.xrecyclerview.R.string.refreshing);
    }

    @Override
    protected void onReFreshDone() {
        mArrowImageView.setVisibility(View.INVISIBLE);
        mProgressBar.setVisibility(View.INVISIBLE);

        mStatusTextView.setText(com.jcodecraeer.xrecyclerview.R.string.refresh_done);
    }

    @Override
    protected void initView() {
        mArrowImageView = findViewById(com.jcodecraeer.xrecyclerview.R.id.listview_header_arrow);
        mStatusTextView = findViewById(com.jcodecraeer.xrecyclerview.R.id.refresh_status_textview);

        //init the progress view
        mProgressBar = findViewById(com.jcodecraeer.xrecyclerview.R.id.listview_header_progressbar);
        AVLoadingIndicatorView progressView = new  AVLoadingIndicatorView(getContext());
        progressView.setIndicatorColor(0xffB5B5B5);
        progressView.setIndicatorId(ProgressStyle.BallSpinFadeLoader);
        mProgressBar.setView(progressView);


        mRotateUpAnim = new RotateAnimation(0.0f, -180.0f,
                Animation.RELATIVE_TO_SELF, 0.5f, Animation.RELATIVE_TO_SELF, 0.5f);
        mRotateUpAnim.setDuration(ROTATE_ANIM_DURATION);
        mRotateUpAnim.setFillAfter(true);
        mRotateDownAnim = new RotateAnimation(-180.0f, 0.0f,
                Animation.RELATIVE_TO_SELF, 0.5f, Animation.RELATIVE_TO_SELF, 0.5f);
        mRotateDownAnim.setDuration(ROTATE_ANIM_DURATION);
        mRotateDownAnim.setFillAfter(true);
    }
}
