package com.xdja.eoa.commonwidget.widget.refreshloading;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xdja.eoa.commonwidget.R;

/**
 * 自定义下拉更多Footer
 *
 * @author hjl
 * @date 2017/5/10
 */

public class CustomLoadingMoreFooter extends BaseLoadingMoreFooter {

    private ImageView loadMoreImg;
    private TextView loadMoreTv;
    private LinearLayout loadingPbar;

    private AnimationDrawable animationDrawable;

    public CustomLoadingMoreFooter(Context context) {
        super(context);
    }

    @Override
    protected void onShowLoading() {
        loadingPbar.setVisibility(View.VISIBLE);
        loadMoreTv.setVisibility(View.VISIBLE);
        loadMoreImg.setVisibility(View.VISIBLE);
        loadMoreTv.setText(R.string.common_widget_loading_more);
        if (!animationDrawable.isRunning()) {
            animationDrawable.start();
        }
    }

    @Override
    protected void onShowNoMore() {
        if (animationDrawable.isRunning()) {
            animationDrawable.stop();
        }
        loadingPbar.setVisibility(View.VISIBLE);
        loadMoreTv.setVisibility(View.VISIBLE);
        loadMoreImg.setVisibility(View.GONE);
        loadMoreTv.setText(R.string.common_widget_load_no_more);
    }

    @Override
    protected void onShowLoadingDone() {
        loadingPbar.setVisibility(View.GONE);
        loadMoreTv.setVisibility(View.GONE);
        loadMoreImg.setVisibility(View.GONE);
        loadMoreTv.setText(R.string.common_widget_load_more_done);
        if (animationDrawable.isRunning()) {
            animationDrawable.stop();
        }
    }

    @Override
    protected void onShowLoadFailure() {
        if (animationDrawable.isRunning()) {
            animationDrawable.stop();
        }
        loadingPbar.setVisibility(View.VISIBLE);
        loadMoreTv.setVisibility(View.VISIBLE);
        loadMoreImg.setVisibility(View.GONE);
        loadMoreTv.setText(R.string.common_widget_information_load_more_failure);
    }

    @Override
    protected void initView() {
        loadMoreImg = findViewById(R.id.iv_loading_more);
        loadMoreTv = findViewById(R.id.tv_loading_more);
        loadingPbar = findViewById(R.id.ll_loading_pbar);
        animationDrawable = (AnimationDrawable) loadMoreImg.getDrawable();
    }

    @Override
    protected int getHeaderResId() {
        return R.layout.layout_list_loading_more_footer;
    }
}
