package com.xdja.eoa.hostlib.inter;

import android.content.Context;

import androidx.annotation.NonNull;

import com.xdja.eoa.hostlib.bean.PluginDownloadInfo;

/**
 * Created by @author zhuruyi on 2020/6/2
 */
public interface PluginUpdateInterface {
    /**
     * 插件是否需要升级
     * @param applicationContext  上下文
     * @return
     */
    boolean needUpdate(Context applicationContext);

    /**
     * 返回插件下载所需要的必要信息
     * @return
     */
    @NonNull
    PluginDownloadInfo getPluginDownloadInfo();

    /**
     * 升级成功，回调
     * 记录新的插件版本
     */
    void updateSuccess();
}
