package com.xdja.eoa.hostlib.util;

import android.util.Log;

/**
 * Created by @author zhuruyi on 2020/3/9
 */
public class LogHelper {
    /** this must be set false before release */
    private static boolean DEBUG = false;

    public static void setLogEnable(){
        DEBUG = true;
    }

    public static void logi(String msg){
        if(!DEBUG) {
            return;
        }
        String tag = Thread.currentThread().getStackTrace()[3].getFileName();
        String funcName = Thread.currentThread().getStackTrace()[3].getMethodName();
        String lineNum = "" + Thread.currentThread().getStackTrace()[3].getLineNumber();
        Log.i(tag, "["+ funcName +"," + lineNum + "]" + msg);
    }

    public static void logd(String msg){
        if(!DEBUG) {
            return;
        }
        String tag = Thread.currentThread().getStackTrace()[3].getFileName();
        String funcName = Thread.currentThread().getStackTrace()[3].getMethodName();
        String lineNum = "" + Thread.currentThread().getStackTrace()[3].getLineNumber();
        Log.d(tag, "["+ funcName +"," + lineNum + "]" + msg);
    }

    public static void logw(String msg){
        if(!DEBUG) {
            return;
        }
        String tag = Thread.currentThread().getStackTrace()[3].getFileName();
        String funcName = Thread.currentThread().getStackTrace()[3].getMethodName();
        String lineNum = "" + Thread.currentThread().getStackTrace()[3].getLineNumber();
        Log.w(tag, "["+ funcName +"," + lineNum + "]" + msg);
    }

    public static void loge(String msg){
        if(!DEBUG) {
            return;
        }
        String tag = Thread.currentThread().getStackTrace()[3].getFileName();
        String funcName = Thread.currentThread().getStackTrace()[3].getMethodName();
        String lineNum = "" + Thread.currentThread().getStackTrace()[3].getLineNumber();
        Log.e(tag, "["+ funcName +"," + lineNum + "]" + msg);
    }
}
