package com.xdja.eoa.hostlib.util;

import com.alibaba.fastjson.JSON;
import com.xdja.eoa.hostlib.bean.PluginConfig;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * 插件配置文件解析工具类
 * {
 * "version": "4.0",
 * "decription": "1 demo 2 test"
 * }
 * Created by @author zhuruyi on 2020/5/15
 */
public class PluginConfigParseUtil {
    public static final String TAG = PluginConfigParseUtil.class.getSimpleName();

    public static PluginConfig parse(String configPath) {
        File configFile = new File(configPath);
        if (!configFile.exists()) {
            LogHelper.logw(configPath + " doesn't exit");
            return null;
        }

        StringBuilder result = new StringBuilder();
        BufferedReader br = null;
        try {
            // 构造一个BufferedReader类来读取文件
            br = new BufferedReader(new InputStreamReader(
                    new FileInputStream(configFile), "UTF-8"));
            String s;
            while ((s = br.readLine()) != null) {
                // 使用readLine方法，一次读一行
                result.append(System.lineSeparator() + s);
            }

            PluginConfig pluginConfig = JSON.parseObject(result.toString(), PluginConfig.class);
            return pluginConfig;
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (null != br) {
                try {
                    br.close();
                } catch (IOException e) {
                    //ignore
                }
            }
        }
        return null;
    }
}
