package com.xdja.eoa.hostlib.util;

import android.content.Context;

import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadSampleListener;
import com.liulishuo.filedownloader.FileDownloader;
import com.xdja.eoa.hostlib.bean.PluginDownloadInfo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * 插件安装包的处理工具类
 * Created by @author zhuruyi on 2020/5/12
 */
public class PluginZipManager {
    public static final String TAG = PluginZipManager.class.getSimpleName();

    private static String getPluginZipDownloadDir(Context mContext) {
        return mContext.getExternalFilesDir("pluginsZip").getAbsolutePath();
    }

    public static String getPluginUnzipDir(Context mContext, String sn, String md5) {
        return mContext.getExternalFilesDir("pluginsUnzip").getAbsolutePath() + "/" + sn + "/" + md5;
    }

    private static void unzipPlugin(String pluginZipPath, String desPlugin, String password) {
        File zipFile = new File(pluginZipPath);
        if (zipFile.exists()) {
            try {
                ZipUtil.unZipFolder(pluginZipPath, desPlugin);
                zipFile.delete();
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            LogHelper.logi("pluginZipPath " + pluginZipPath + " doesn't exist");
        }
    }

    public static void downloadPluginZipAndUnzip(Context mContext, final PluginDownloadInfo downloadInfo, final DownloadCallback downloadCallback) {
        final String downloadZipPath = PluginZipManager.getPluginZipDownloadDir(mContext) + "/" + downloadInfo.getMd5() + ".zip";
        File downZipFile = new File(downloadZipPath);
        if (downZipFile.exists()) {
            downZipFile.delete();
        }

        final String unzipDir = getPluginUnzipDir(mContext, downloadInfo.getSn(), downloadInfo.getMd5());
        LogHelper.logi("will down " + downloadInfo.getUrl());
        final long start = System.currentTimeMillis();
        FileDownloader.getImpl().create(downloadInfo.getUrl())
                .setPath(downloadZipPath)
                .setListener(new FileDownloadSampleListener() {
                    @Override
                    protected void started(BaseDownloadTask task) {
                        LogHelper.logd("started");
                        if (downloadCallback != null) {
                            downloadCallback.onStart();
                        }
                    }

                    @Override
                    protected void progress(BaseDownloadTask task, int soFarBytes, int totalBytes) {
                        if (downloadCallback != null) {
                            if (totalBytes != 0) {
                                LogHelper.logi("download progress, soFarBytes =" + soFarBytes + ",totalBytes =" + totalBytes);
                                downloadCallback.onProgress((int) ((float) soFarBytes / totalBytes * 100));
                            } else {
                                LogHelper.logi("download fail, totalBytes is 0");
                            }
                        }
                    }

                    @Override
                    protected void completed(BaseDownloadTask task) {
                        downloadCallback.onProgress(100);
                        //下载完成线程已切到主线程，所以此处另起线程处理解压任务
                        new Thread(new Runnable() {
                            @Override
                            public void run() {
                                LogHelper.logi("download plugin coast " + (System.currentTimeMillis() - start) + " ms");
                                long localS = System.currentTimeMillis();
                                boolean isValid = validZip(downloadZipPath, downloadInfo.getMd5());
                                LogHelper.logi("valid plugin coast " + (System.currentTimeMillis() - localS) + " ms");

                                if (!isValid) {
                                    LogHelper.loge(downloadZipPath + " zip file is invalid, error");
                                    if (downloadCallback != null) {
                                        downloadCallback.onError();
                                    }
                                } else {
                                    localS = System.currentTimeMillis();
                                    unzipPlugin(downloadZipPath, unzipDir, null);
                                    LogHelper.logi("unzip plugin coast " + (System.currentTimeMillis() - localS) + " ms");
                                }
                                if (downloadCallback != null) {
                                    downloadCallback.onSuccess(unzipDir);
                                }
                            }
                        }).start();
                    }

                    @Override
                    protected void error(BaseDownloadTask task, Throwable e) {
                        if (downloadCallback != null) {
                            downloadCallback.onError();
                        }
                        LogHelper.loge((e.getMessage()));
                    }
                }).start();
    }

    public static boolean validZip(String pluginZipPath, String md5) {
        try {
            return md5.equals(getFileMd5(pluginZipPath));
        } catch (NoSuchAlgorithmException | IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getFileMd5(String filePath) throws NoSuchAlgorithmException, IOException {
        InputStream in = null;
        StringBuffer md5 = new StringBuffer();
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] dataBytes = new byte[1024];
        try {
            in = new FileInputStream(new File(filePath));
            int nread;
            while ((nread = in.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        byte[] mdbytes = md.digest();
        /*convert the byte to hex format*/
        for (int i = 0; i < mdbytes.length; i++) {
            md5.append(Integer.toString((mdbytes[i] & 0xff) + 0x100, 16).substring(1));
        }
        return md5.toString().toLowerCase();
    }


    public interface DownloadCallback {
        void onStart();

        void onError();

        void onSuccess(String unZipDir);

        void onProgress(int progress);
    }
}
