/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imagecontainer;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.StyleableRes;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.bumptech.glide.Glide;
import com.xdja.imagecontainer.ImageDetailActivity;
import com.xdja.imagecontainer.R;
import java.util.ArrayList;
import java.util.List;

public class ImageContainer
extends LinearLayout {
    private static final int[] mAttr = new int[]{0x1010114, 0x1010115, 0x1010118};
    private static final int ATTR_HORIZONTAL_SPACING = 0;
    @StyleableRes
    private static final int ATTR_VERTICAL_SPACING = 1;
    @StyleableRes
    private static final int ATTR_NUM_COLUMNS = 2;
    private SparseArray<View> viewMap = new SparseArray();
    private SparseArray<LinearLayout> layoutMap = new SparseArray();
    protected ImageContainerAdapter adapter;
    protected ArrayList<String> images;
    private boolean isShowDetail;
    private int verSpacing;
    private int horSpacing;
    private int numColumns;
    private int itemWidth;

    public ImageContainer(Context context) {
        this(context, null);
    }

    public ImageContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(1);
        TypedArray a = context.obtainStyledAttributes(attrs, mAttr);
        this.horSpacing = a.getDimensionPixelOffset(0, 0);
        this.verSpacing = a.getDimensionPixelOffset(1, 0);
        this.numColumns = a.getInt(2, 3);
        a.recycle();
    }

    public void setImages(@NonNull List<String> images, boolean isShowDetail) {
        this.images = new ArrayList<String>(images);
        this.isShowDetail = isShowDetail;
        if (this.adapter == null) {
            this.adapter = new ImageContainerAdapter(this.getContext(), images);
        } else {
            this.adapter.setData(images);
        }
        this.updateData();
    }

    public void updateData() {
        int i;
        int count = this.adapter.getCount();
        int length = this.viewMap.size();
        for (i = 0; i < length; ++i) {
            if (i < count) {
                ((View)this.viewMap.get(i)).setVisibility(0);
                continue;
            }
            ((View)this.viewMap.get(i)).setVisibility(8);
        }
        length = this.layoutMap.size();
        for (i = 0; i < length; ++i) {
            if (i < count / this.numColumns + 1) {
                ((LinearLayout)this.layoutMap.get(i)).setVisibility(0);
                continue;
            }
            ((LinearLayout)this.layoutMap.get(i)).setVisibility(8);
        }
        for (i = 0; i < count / this.numColumns + 1; ++i) {
            LinearLayout linearLayout;
            int num = this.numColumns;
            if (i == count / this.numColumns) {
                num = count % this.numColumns;
            }
            if (this.layoutMap.size() > i) {
                linearLayout = (LinearLayout)this.layoutMap.get(i);
            } else {
                linearLayout = new LinearLayout(this.getContext());
                linearLayout.setOrientation(0);
            }
            for (int j = 0; j < num; ++j) {
                int position = i * this.numColumns + j;
                View convertView = (View)this.viewMap.get(position);
                View resultView = this.adapter.getView(position, convertView, (ViewGroup)linearLayout);
                if (resultView == convertView) continue;
                linearLayout.addView(resultView, (ViewGroup.LayoutParams)this.getHorLayoutParams(j == 0));
                this.viewMap.put(position, (Object)resultView);
                if (!this.isShowDetail) continue;
                final int finalI = i;
                final int finalJ = j;
                resultView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ImageContainer.this.onItemClicked(finalI * ImageContainer.this.numColumns + finalJ);
                    }
                });
            }
            if (this.layoutMap.get(i) != null) continue;
            this.addView((View)linearLayout, (ViewGroup.LayoutParams)this.getVerLayoutParams(i == 0));
            this.layoutMap.put(i, (Object)linearLayout);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (oldw != w) {
            this.itemWidth = (w - (this.numColumns - 1) * this.horSpacing) / this.numColumns;
            for (int i = 0; i < this.viewMap.size(); ++i) {
                ViewGroup.LayoutParams params = ((View)this.viewMap.valueAt(i)).getLayoutParams();
                params.height = this.itemWidth;
                params.width = this.itemWidth;
            }
            this.requestLayout();
        }
    }

    private LinearLayout.LayoutParams getHorLayoutParams(boolean isFirst) {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(this.itemWidth, this.itemWidth);
        if (!isFirst) {
            layoutParams.setMargins(this.horSpacing, 0, 0, 0);
        }
        return layoutParams;
    }

    private LinearLayout.LayoutParams getVerLayoutParams(boolean isFirst) {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        if (!isFirst) {
            layoutParams.setMargins(0, this.verSpacing, 0, 0);
        }
        return layoutParams;
    }

    protected void onItemClicked(int position) {
        if (position < this.images.size()) {
            ImageDetailActivity.startActivity((Activity)this.getContext(), this.images, position);
        }
    }

    private static class ImageContainerAdapter
    extends BaseAdapter {
        private Context context;
        private List<String> images;

        ImageContainerAdapter(Context context, List<String> images) {
            this.context = context;
            this.images = images;
        }

        public int getCount() {
            return this.images.size();
        }

        public Object getItem(int position) {
            return null;
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = new ImageView(this.context);
                ((ImageView)convertView).setScaleType(ImageView.ScaleType.CENTER_CROP);
            }
            Glide.with((Context)this.context).load(this.images.get(position)).placeholder(R.drawable.imagecontainer_ic_default_image).error(R.drawable.imagecontainer_ic_default_image).into((ImageView)convertView);
            return convertView;
        }

        public void setData(List<String> data) {
            this.images = data;
        }
    }
}

