/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imagecontainer;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.blankj.utilcode.utils.FileUtils;
import com.bumptech.glide.Glide;
import com.xdja.eoa.commonutil.BitMapUtils;
import com.xdja.eoa.commonutil.EoaCacheFileConstant;
import com.xdja.eoa.commonutil.JsonManager;
import com.xdja.eoa.commonutil.Pair;
import com.xdja.eoa.commonwidget.listener.OnCommonListener;
import com.xdja.eoa.commonwidget.widget.utils.EoaToast;
import com.xdja.eoa.facadeservice.FacadeServiceManager;
import com.xdja.eoa.facadeservice.MainFacade;
import com.xdja.imagecontainer.InkPageIndicator;
import com.xdja.imagecontainer.R;
import com.xdja.imagecontainer.ViewPagerFixed;
import com.xdja.imagecontainer.adapter.ImageAdapter;
import com.xdja.imagecontainer.bean.FavoriteContentTypeImage;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;

@Route(path="/image_container/image_detail")
public class ImageDetailActivity
extends AppCompatActivity {
    public static final String TAG = ImageDetailActivity.class.getSimpleName();
    public static final String URL_MAP = "url_map";
    public static final String CURRENT_POSITION = "currentPosition";
    public static final String PERSON_NAME = "PERSON_NAME";
    public static final String PERSON_ICON = "PERSON_ICON";
    public static final String TAG_PLACEHOLDER = "TAG_PLACEHOLDER";
    public static final String TAG_OPERATE_LISTENER = "TAG_OPERATE_LISTENER";
    public static final String TAG_OPERATE_NAME = "TAG_OPERATE_NAME";
    ViewPagerFixed viewPager;
    InkPageIndicator indicator;
    private ImageAdapter adapter;
    private ImageView ivOperate;
    private ArrayList<Pair<String, String>> urlList;
    private Drawable placeHolder;
    private static OnCommonListener onCommonListener;
    private MainFacade mainFacade;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = this.getWindow();
        this.requestWindowFeature(1);
        int flag = 1024;
        window.setFlags(flag, flag);
        this.attachView(savedInstanceState);
        this.initView(savedInstanceState);
    }

    protected void attachView(@Nullable Bundle savedInstanceState) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.getWindow().addFlags(0x4000000);
            this.getWindow().addFlags(0x8000000);
        }
        this.setContentView(R.layout.imagecontainer_activity_image_detail);
    }

    protected void initView(@Nullable Bundle savedInstanceState) {
        this.urlList = (ArrayList)this.getIntent().getSerializableExtra(URL_MAP);
        byte[] placeholderBytes = this.getIntent().getByteArrayExtra(TAG_PLACEHOLDER);
        if (placeholderBytes != null) {
            Bitmap placeHolderBm = BitMapUtils.bytes2Bitmap((byte[])placeholderBytes);
            this.placeHolder = new BitmapDrawable(this.getResources(), placeHolderBm);
        }
        int currentPosition = this.getIntent().getIntExtra(CURRENT_POSITION, 0);
        this.viewPager = (ViewPagerFixed)this.findViewById(R.id.viewPager_image_detail);
        this.indicator = (InkPageIndicator)this.findViewById(R.id.indicator_image_detail);
        this.adapter = new ImageAdapter((Context)this, this.urlList, this.placeHolder);
        this.viewPager.setAdapter(this.adapter);
        this.indicator.setViewPager(this.viewPager);
        this.viewPager.setCurrentItem(currentPosition, false);
        this.viewPager.setFocusable(false);
        if (this.urlList.size() == 1) {
            this.indicator.setVisibility(8);
        }
        this.ivOperate = (ImageView)this.findViewById(R.id.iv_operate);
        this.operateShowSave(currentPosition, this.urlList);
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                ImageDetailActivity.this.operateShowSave(position, ImageDetailActivity.this.urlList);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.ivOperate.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int position = ImageDetailActivity.this.viewPager.getCurrentItem();
                String s = (String)((Pair)((ImageDetailActivity)ImageDetailActivity.this).urlList.get((int)position)).second;
                File file = new File(s);
                if (file.exists()) {
                    Toast.makeText((Context)ImageDetailActivity.this, (int)R.string.imagecontainer_file_exist, (int)0).show();
                    return;
                }
                if (!ImageDetailActivity.this.adapter.isDownloaded(position)) {
                    Toast.makeText((Context)ImageDetailActivity.this, (int)R.string.imagecontainer_file_not_downloaded, (int)0).show();
                    return;
                }
                ImageDetailActivity.this.showSaveDialog(position);
            }
        });
    }

    private void operateShowSave(int position, ArrayList<Pair<String, String>> urlList) {
        String s = (String)urlList.get((int)position).second;
        File file = new File(s);
        if (file.exists()) {
            this.ivOperate.setVisibility(8);
        } else {
            this.ivOperate.setVisibility(0);
        }
    }

    public void showSaveDialog(final int position) {
        final AlertDialog dlg = new AlertDialog.Builder((Context)this).create();
        dlg.show();
        Window window = dlg.getWindow();
        window.setContentView(R.layout.imagecontainer_preview_more_dialog);
        if (!TextUtils.isEmpty((CharSequence)this.getPersonName())) {
            TextView tv_fav = (TextView)window.findViewById(R.id.tv_fav);
            tv_fav.setVisibility(0);
            tv_fav.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    dlg.dismiss();
                    FavoriteContentTypeImage typeImage = new FavoriteContentTypeImage();
                    typeImage.setFavFrom("FAV_FROM_WORKCICLE");
                    typeImage.setImageUrlOrigin((String)((Pair)((ImageDetailActivity)ImageDetailActivity.this).urlList.get((int)position)).second);
                    typeImage.setImageUrlPoster((String)((Pair)((ImageDetailActivity)ImageDetailActivity.this).urlList.get((int)position)).first);
                    typeImage.setPersonIocn(ImageDetailActivity.this.getPersonIcon());
                    typeImage.setPersonName(ImageDetailActivity.this.getPersonName());
                    if (ImageDetailActivity.this.mainFacade == null) {
                        ImageDetailActivity.this.mainFacade = (MainFacade)FacadeServiceManager.getInstance().getFacade("main_facade");
                    }
                    if (ImageDetailActivity.this.mainFacade != null) {
                        ImageDetailActivity.this.mainFacade.addFavorite(3, JsonManager.beanToJson((Object)typeImage), ImageDetailActivity.this.getPersonName());
                    }
                }
            });
        }
        if (this.getCanOperation() && !TextUtils.isEmpty((CharSequence)this.getOperateName())) {
            TextView tvOperate = (TextView)window.findViewById(R.id.tv_operate);
            tvOperate.setVisibility(0);
            tvOperate.setText((CharSequence)this.getOperateName());
            tvOperate.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (onCommonListener != null) {
                        onCommonListener.onOperate(null);
                    }
                    dlg.dismiss();
                    ImageDetailActivity.this.finish();
                }
            });
        }
        TextView save2Disk = (TextView)window.findViewById(R.id.tv_save);
        save2Disk.setText((CharSequence)"\u4fdd\u5b58\u56fe\u7247");
        save2Disk.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dlg.dismiss();
                SaveImageTask saveImageTask = new SaveImageTask();
                saveImageTask.execute(new String[]{(String)((Pair)((ImageDetailActivity)ImageDetailActivity.this).urlList.get((int)position)).second});
            }
        });
    }

    public static void startActivity(Activity activity, int position, ArrayList<Pair<String, String>> images) {
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, ImageDetailActivity.class);
        intent.putExtra(URL_MAP, images);
        intent.putExtra(CURRENT_POSITION, position);
        activity.startActivity(intent);
    }

    public static void startActivity(Activity activity, int position, ArrayList<Pair<String, String>> images, String personName, String personIcon) {
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, ImageDetailActivity.class);
        intent.putExtra(URL_MAP, images);
        intent.putExtra(CURRENT_POSITION, position);
        intent.putExtra(PERSON_NAME, personName);
        intent.putExtra(PERSON_ICON, personIcon);
        activity.startActivity(intent);
    }

    public static void startActivity(Activity activity, ArrayList<String> images, int position) {
        if (activity == null) {
            return;
        }
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        for (String image : images) {
            list.add((Pair<String, String>)new Pair((Object)image, (Object)image));
        }
        ImageDetailActivity.startActivity(activity, position, list);
    }

    public static void startActivity(Activity activity, ArrayList<String> images, int position, String operateName, OnCommonListener listener) {
        if (activity == null) {
            return;
        }
        onCommonListener = listener;
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (String image : images) {
            list.add(new Pair((Object)image, (Object)image));
        }
        Intent intent = new Intent((Context)activity, ImageDetailActivity.class);
        intent.putExtra(URL_MAP, list);
        intent.putExtra(CURRENT_POSITION, position);
        intent.putExtra(TAG_OPERATE_LISTENER, true);
        intent.putExtra(TAG_OPERATE_NAME, operateName);
        activity.startActivity(intent);
    }

    private String getPersonName() {
        return this.getIntent().getStringExtra(PERSON_NAME);
    }

    private String getPersonIcon() {
        return this.getIntent().getStringExtra(PERSON_ICON);
    }

    private boolean getCanOperation() {
        return this.getIntent().getBooleanExtra(TAG_OPERATE_LISTENER, false);
    }

    private String getOperateName() {
        return this.getIntent().getStringExtra(TAG_OPERATE_NAME);
    }

    private class SaveImageTask
    extends AsyncTask<String, Long, String> {
        private SaveImageTask() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected void onPostExecute(String filePath) {
            super.onPostExecute((Object)filePath);
            if (TextUtils.isEmpty((CharSequence)filePath)) {
                Toast.makeText((Context)ImageDetailActivity.this.getApplicationContext(), (CharSequence)"\u4fdd\u5b58\u5931\u8d25", (int)0).show();
                return;
            }
            File destFile = new File(filePath);
            Uri uri = Uri.fromFile((File)destFile);
            Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", uri);
            ImageDetailActivity.this.sendBroadcast(intent);
            EoaToast.showBottomToast((Context)ImageDetailActivity.this.getApplicationContext(), (String)("\u56fe\u7247\u5df2\u4fdd\u5b58\u81f3" + destFile.getAbsolutePath()));
        }

        protected String doInBackground(String ... strings) {
            if (strings == null || strings.length < 1) {
                return "";
            }
            String url = strings[0];
            if (TextUtils.isEmpty((CharSequence)url)) {
                return "";
            }
            try {
                boolean success;
                File sourceFile = (File)Glide.with((FragmentActivity)ImageDetailActivity.this).load(url).downloadOnly(Integer.MIN_VALUE, Integer.MIN_VALUE).get();
                String imageCachePath = EoaCacheFileConstant.getOACacheFileDownLoadPath();
                String fileName = System.currentTimeMillis() + ".jpg";
                File destFile = new File(imageCachePath, fileName);
                if (destFile.exists()) {
                    destFile.delete();
                }
                if (!(success = FileUtils.copyFile((File)sourceFile, (File)destFile))) {
                    return "";
                }
                return destFile.getAbsolutePath();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                return "";
            }
        }
    }
}

