/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imagecontainer.adapter;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.DrawableRequestBuilder;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.xdja.eoa.commonutil.Pair;
import com.xdja.imagecontainer.R;
import com.xdja.imagecontainer.photoview.PhotoView;
import com.xdja.imagecontainer.photoview.PhotoViewAttacher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ImageAdapter
extends PagerAdapter {
    private final Context context;
    private final ArrayList<Pair<String, String>> urlList;
    private Drawable placeHolder;
    private LayoutInflater mLayoutInflater;
    private Set<Integer> downloadedPositions = new HashSet<Integer>();

    public ImageAdapter(Context context, ArrayList<Pair<String, String>> urlList, Drawable placeHolder) {
        this.context = context;
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        this.urlList = urlList;
        this.placeHolder = placeHolder;
    }

    public int getCount() {
        return this.urlList.size();
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    public Object instantiateItem(ViewGroup container, final int position) {
        View imageContainerView = this.mLayoutInflater.inflate(R.layout.imagecontainer_layout_image, null);
        final PhotoView photoViewThumb = (PhotoView)imageContainerView.findViewById(R.id.photoview_thumb);
        final PhotoView photoViewDetail = (PhotoView)imageContainerView.findViewById(R.id.photoview_detail);
        Object palceHolder = null;
        photoViewThumb.setVisibility(0);
        this.loadImageByGlide((String)this.urlList.get((int)position).first, position, photoViewThumb, new RequestListener<String, GlideDrawable>(){

            public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                photoViewThumb.setVisibility(8);
                photoViewDetail.setVisibility(0);
                ImageAdapter.this.loadImageByGlide((String)((Pair)((ImageAdapter)ImageAdapter.this).urlList.get((int)position)).second, position, photoViewDetail, (RequestListener<String, GlideDrawable>)null, resource.getCurrent());
                return false;
            }
        }, this.placeHolder);
        container.addView(imageContainerView);
        return imageContainerView;
    }

    private void loadImageByGlide(String url, final int position, final PhotoView photoView, final RequestListener<String, GlideDrawable> requestListener, Drawable placeholder) {
        DrawableRequestBuilder builder = Glide.with((Context)this.context).load(url).crossFade().diskCacheStrategy(DiskCacheStrategy.ALL);
        builder.listener((RequestListener)new RequestListener<String, GlideDrawable>(){

            public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                if (requestListener != null) {
                    return requestListener.onException(e, (Object)model, target, isFirstResource);
                }
                return false;
            }

            public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                ImageAdapter.this.downloadedPositions.add(position);
                photoView.setOnPhotoTapListener(new PhotoViewAttacher.OnPhotoTapListener(){

                    @Override
                    public void onPhotoTap(View view, float x, float y) {
                        ((Activity)ImageAdapter.this.context).finish();
                    }

                    @Override
                    public void onOutsidePhotoTap() {
                    }
                });
                if (requestListener != null) {
                    return requestListener.onResourceReady((Object)resource, (Object)model, target, isFromMemoryCache, isFirstResource);
                }
                return false;
            }
        });
        if (placeholder != null) {
            builder.placeholder(placeholder);
        }
        builder.into((ImageView)photoView);
    }

    public boolean isDownloaded(int position) {
        return this.downloadedPositions.contains(position);
    }
}

