/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imagecontainer.utils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

public class InsertMediaUtil {
    @Nullable
    public static File insertMedia(Context context, File sourceFile, String destDirName, String destFileName) {
        try {
            boolean success;
            File destFile = new File(InsertMediaUtil.getSaveDir(destDirName), destFileName);
            boolean bl = success = destFile.exists() || InsertMediaUtil.copyFile(sourceFile.getPath(), destFile.getPath());
            if (success) {
                Uri uri = Uri.fromFile((File)destFile);
                Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", uri);
                context.sendBroadcast(intent);
                return destFile;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @NonNull
    public static File getSaveDir(String dirName) {
        File file;
        String cachePath = Environment.getExternalStorageDirectory().getPath() + "/eoa";
        if (!TextUtils.isEmpty((CharSequence)dirName)) {
            cachePath = cachePath + "/" + dirName;
        }
        if (!(file = new File(cachePath)).exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static boolean copyFile(String oldPath, String newPath) {
        try {
            int bytesum = 0;
            int byteread = 0;
            File oldfile = new File(oldPath);
            if (oldfile.exists()) {
                FileInputStream inStream = new FileInputStream(oldPath);
                FileOutputStream fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                    System.out.println(bytesum += byteread);
                    fs.write(buffer, 0, byteread);
                }
                ((InputStream)inStream).close();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

