package com.xdja.eoa.sdk.constant;

import android.util.Log;

/**
 * @author jarlen
 * @date 2020/4/14
 */
public class SdkLog {
    public static void d(String msg) {
        if (Log.isLoggable(SdkConstant.TAG_LOG, Log.DEBUG)) {
            Thread currentThread = Thread.currentThread();
            String lineNum = "" + currentThread.getStackTrace()[3].getLineNumber();
            String className = currentThread.getStackTrace()[3].getFileName();
            Log.d(SdkConstant.TAG_LOG, "[" + className + ":" + lineNum + "]  " + msg);
        }
    }

    public static void w(String msg) {
        if (Log.isLoggable(SdkConstant.TAG_LOG, Log.WARN)) {
            Thread currentThread = Thread.currentThread();
            String lineNum = "" + currentThread.getStackTrace()[3].getLineNumber();
            String className = currentThread.getStackTrace()[3].getFileName();
            Log.w(SdkConstant.TAG_LOG, "[" + className + ":" + lineNum + "]  " + msg);
        }
    }

    public static void w(Throwable throwable) {
        if (Log.isLoggable(SdkConstant.TAG_LOG, Log.WARN)) {
            Thread currentThread = Thread.currentThread();
            String lineNum = "" + currentThread.getStackTrace()[3].getLineNumber();
            String className = currentThread.getStackTrace()[3].getFileName();
            Log.w(SdkConstant.TAG_LOG, "[" + className + ":" + lineNum + "]  " + throwable);
        }
    }

    public static void e(String msg) {
        if (Log.isLoggable(SdkConstant.TAG_LOG, Log.ERROR)) {
            Thread currentThread = Thread.currentThread();
            String lineNum = "" + currentThread.getStackTrace()[3].getLineNumber();
            String className = currentThread.getStackTrace()[3].getFileName();
            Log.e(SdkConstant.TAG_LOG, "[" + className + ":" + lineNum + "]  " + msg);
        }
    }
}
