package com.xdja.eoa.sdk.data;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * @author jarlen
 * @date 2020/4/3
 * 应用信息
 */
public class AppInfo implements Parcelable {

    private String appId;
    private String appName;
    private String appIcon;
    private String appServerUrl;

    public AppInfo() {
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppIcon() {
        return appIcon;
    }

    public void setAppIcon(String appIcon) {
        this.appIcon = appIcon;
    }

    public String getAppServerUrl() {
        return appServerUrl;
    }

    public void setAppServerUrl(String appServerUrl) {
        this.appServerUrl = appServerUrl;
    }

    protected AppInfo(Parcel in) {
        appId = in.readString();
        appName = in.readString();
        appIcon = in.readString();
        appServerUrl = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(appId);
        dest.writeString(appName);
        dest.writeString(appIcon);
        dest.writeString(appServerUrl);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<AppInfo> CREATOR = new Creator<AppInfo>() {
        @Override
        public AppInfo createFromParcel(Parcel in) {
            return new AppInfo(in);
        }

        @Override
        public AppInfo[] newArray(int size) {
            return new AppInfo[size];
        }
    };
}
