package com.xdja.eoa.sdk.data.param;

import java.util.List;

/**
 * @author jarlen
 * @date 2020/3/28
 * 接口认证参数
 */
public class ApiAccessConfigParam {

    private SignMessage signMessage;

    private List<String> methodList;

    public SignMessage getSignMessage() {
        return signMessage;
    }

    public void setSignMessage(SignMessage signMessage) {
        this.signMessage = signMessage;
    }

    public List<String> getMethodList() {
        return methodList;
    }

    public void setMethodList(List<String> methodList) {
        this.methodList = methodList;
    }

    public class SignMessage {

        /**
         * 企业ID
         */
        private String corpId;

        /**
         * 应用ID
         */
        private String appId;

        /**
         * 签名字符串
         */
        private String signature;

        /**
         * 随机串
         */
        private String noncestr;

        /**
         * 时间戳
         */
        private long timestamp;
        /**
         * 1 内部应用 
         * 0 非内部应用
         */
        private int innerAppFlag;

        public String getCorpId() {
            return corpId;
        }

        public void setCorpId(String corpId) {
            this.corpId = corpId;
        }

        public String getAppId() {
            return appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getSignature() {
            return signature;
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }

        public String getNoncestr() {
            return noncestr;
        }

        public void setNoncestr(String noncestr) {
            this.noncestr = noncestr;
        }

        public long getTimestamp() {
            return timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public int getInnerAppFlag() {
            return innerAppFlag;
        }

        public void setInnerAppFlag(int innerAppFlag) {
            this.innerAppFlag = innerAppFlag;
        }
    }


}
