package com.xdja.eoa.sdk.data.param;

import java.util.List;

public class LocationDetailWithRangeStartParams {

    /**
     * 定位详情标题
     */
    private String detailTitle;

    /**
     * 单次定位
     */
    private boolean onceLocation;

    /**
     * 连续定位时间间隔，单位：毫秒，默认值：2000毫秒
     */
    private int interval = 2000;

    /**
     * 范围列表
     */
    private List<LocationRange> rangeList;

    /**
     * 视图定位地址
     */
    private LocationLatLng currentLocation;

    public LocationDetailWithRangeStartParams() {
    }

    public LocationDetailWithRangeStartParams(String detailTitle, boolean onceLocation, int interval,
                                              List<LocationRange> rangeList, LocationLatLng currentLocation) {
        this.detailTitle = detailTitle;
        this.onceLocation = onceLocation;
        this.interval = interval;
        this.rangeList = rangeList;
        this.currentLocation = currentLocation;
    }

    public String getDetailTitle() {
        return detailTitle;
    }

    public void setDetailTitle(String detailTitle) {
        this.detailTitle = detailTitle;
    }

    public boolean isOnceLocation() {
        return onceLocation;
    }

    public void setOnceLocation(boolean onceLocation) {
        this.onceLocation = onceLocation;
    }

    public int getInterval() {
        return interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public List<LocationRange> getRangeList() {
        return rangeList;
    }

    public void setRangeList(List<LocationRange> rangeList) {
        this.rangeList = rangeList;
    }

    public LocationLatLng getCurrentLocation() {
        return currentLocation;
    }

    public void setCurrentLocation(LocationLatLng currentLocation) {
        this.currentLocation = currentLocation;
    }

    public static class LocationRange {

        /**
         * 经度
         */
        private double longitude;
        /**
         * 纬度
         */
        private double latitude;
        /**
         * 范围 以米为单位
         */
        private long distanceRange;

        public LocationRange() {
        }

        public LocationRange(double longitude, double latitude, long distanceRange) {
            this.longitude = longitude;
            this.latitude = latitude;
            this.distanceRange = distanceRange;
        }

        public double getLongitude() {
            return longitude;
        }

        public double getLatitude() {
            return latitude;
        }

        public long getDistanceRange() {
            return distanceRange;
        }

        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }

        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        public void setDistanceRange(long distanceRange) {
            this.distanceRange = distanceRange;
        }
    }

    public static class LocationLatLng {

        private double latitude;
        private double longitude;

        public LocationLatLng() {
        }

        public LocationLatLng(double latitude, double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }

        public double getLatitude() {
            return latitude;
        }

        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        public double getLongitude() {
            return longitude;
        }

        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }
    }
}
