package com.xdja.eoa.sdk.data.param;

/**
 * @author jarlen
 * @date 2020/4/18
 * 选择时间参数(时分秒)
 */
public class TimeSelectParams {
    /**
     * 初步选中的小时(0~23或0~11)
     * <br>可不填</>
     */
    private String defaultHours;

    /**
     * 初步选中的分钟(0~59)
     * <br>可不填</>
     */
    private String defaultMinutes;

    /**
     * 初步选中的秒(0~59)
     * <br>可不填</>
     */
    private String defaultSeconds;

    /**
     * 是否是24小时制，默认24小时制
     */
    private boolean hour24Format;

    /**
     * 选择类型(默认时分秒)
     * 1表示选择时
     * 2表示选择分
     * 3表示选择秒
     * 4表示选择时分
     * 5表示选择分秒
     * 6表示选择时分秒
     */
    private int type;

    public String getDefaultHours() {
        return defaultHours;
    }

    public void setDefaultHours(String defaultHours) {
        this.defaultHours = defaultHours;
    }

    public String getDefaultMinutes() {
        return defaultMinutes;
    }

    public void setDefaultMinutes(String defaultMinutes) {
        this.defaultMinutes = defaultMinutes;
    }

    public String getDefaultSeconds() {
        return defaultSeconds;
    }

    public void setDefaultSeconds(String defaultSeconds) {
        this.defaultSeconds = defaultSeconds;
    }

    public boolean isHour24Format() {
        return hour24Format;
    }

    public void setHour24Format(boolean hour24Format) {
        this.hour24Format = hour24Format;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }
}
