package com.xdja.eoa.sdk;

import com.xdja.eoa.sdk.annotation.ModuleApp;
import com.xdja.eoa.sdk.module.ModuleApplication;

public class MethodParam {
    private String method;
    private String version;
    private String apiAccessCode;
    private String appSn;
    private String params;
    private String mark;

    private MethodParam(Builder builder) {
        this.apiAccessCode = builder.apiAccessCode;
        this.method = builder.method;
        this.version = builder.version;
        this.params = builder.params;
        this.mark = builder.mark;
        this.appSn = builder.appSn;
    }

    public String getMethod() {
        return method;
    }

    public String getVersion() {
        return version;
    }

    public String getApiAccessCode() {
        return apiAccessCode;
    }

    public String getParams() {
        return params;
    }

    public String getMark() {
        return mark;
    }

    public String getAppSn() {
        return appSn;
    }

    @Override
    public String toString() {
        return "MethodParam{" +
                "method='" + method + '\'' +
                ", version='" + version + '\'' +
                ", apiAccessCode='" + apiAccessCode + '\'' +
                ", appSn='" + appSn + '\'' +
                ", params='" + params + '\'' +
                ", mark='" + mark + '\'' +
                '}';
    }

    public static class Builder {
        String method;
        String version;
        String apiAccessCode;
        String params;
        String mark;
        String appSn;

        public Builder(Class<? extends ModuleApplication> moduleClass) {
            String appSn = moduleClass.getAnnotation(ModuleApp.class).appSn();
            this.appSn = appSn;
        }

        public Builder setApiAccessCode(String apiAccessCode) {
            this.apiAccessCode = apiAccessCode;
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setParams(String params) {
            this.params = params;
            return this;
        }

        public Builder setMark(String mark) {
            this.mark = mark;
            return this;
        }

        public MethodParam create() {
            return new MethodParam(this);
        }
    }

}
