/*
 * Decompiled with CFR 0.152.
 */
package com.ldy.splitbase;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import java.util.Stack;

public class ActivityStack {
    private static Stack<Activity> activityStack;
    private static ActivityStack instance;

    private ActivityStack() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActivityStack instance() {
        if (instance != null) return instance;
        Class<ActivityStack> clazz = ActivityStack.class;
        synchronized (ActivityStack.class) {
            if (instance != null) return instance;
            instance = new ActivityStack();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    void addActivity(Activity activity) {
        if (activityStack == null) {
            activityStack = new Stack();
        }
        activityStack.add(activity);
    }

    public Activity current() {
        return (Activity)activityStack.lastElement();
    }

    public <T extends Activity> T findActivity(Class<T> activityClass) {
        for (Activity activity : activityStack) {
            if (!activity.getClass().equals(activityClass)) continue;
            return (T)activity;
        }
        return null;
    }

    public void finishActivity() {
        Activity activity = (Activity)activityStack.lastElement();
        this.finishActivity(activity);
    }

    void finishActivity(Activity activity) {
        if (activity != null) {
            activity.finish();
        }
    }

    public void finishToActivity(Class<? extends Activity> activityClass) {
        while (!activityStack.peek().getClass().equals(activityClass)) {
            activityStack.pop().finish();
        }
    }

    public void removeActivity(Activity activity) {
        if (activity != null) {
            activityStack.remove(activity);
        }
    }

    public void finishActivity(Class<?> cls) {
        for (Activity activity : activityStack) {
            if (!activity.getClass().equals(cls)) continue;
            this.finishActivity(activity);
        }
    }

    public void finishAllActivity() {
        int size = activityStack.size();
        for (int i = 0; i < size; ++i) {
            if (null == activityStack.get(i)) continue;
            ((Activity)activityStack.get(i)).finish();
        }
        activityStack.clear();
    }

    public boolean isActivityExist(String activityName) {
        if (null == activityStack || activityStack.size() == 0) {
            return false;
        }
        int size = activityStack.size();
        for (int i = 0; i < size; ++i) {
            String localClassName;
            if (null == activityStack.get(i) || !(localClassName = ((Activity)activityStack.get(i)).getLocalClassName()).contains(activityName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appExit(Context context, Boolean isBackground) {
        try {
            this.finishAllActivity();
            ActivityManager activityMgr = (ActivityManager)context.getSystemService("activity");
            activityMgr.restartPackage(context.getPackageName());
        }
        catch (Exception exception) {
        }
        finally {
            if (!isBackground.booleanValue()) {
                System.exit(0);
            }
        }
    }
}

