/*
 * Decompiled with CFR 0.152.
 */
package com.ldy.splitbase;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.ldy.splitbase.modulecommunication.event.EventControl;
import com.ldy.splitbase.modulecommunication.event.plug.EventLogPlug;
import com.ldy.splitbase.receiver.ModuleInitReceiver;
import java.util.ArrayList;
import java.util.List;

public class SplitBaseApp {
    private static Context context;
    private List<ModuleInitReceiver> receivers;

    public SplitBaseApp(Application application) {
        context = application;
    }

    public void onCreate() {
        this.receivers = this.getModuleInitReceivers();
        this.moduleInit(this.receivers);
        EventControl.instance().registerPlug(new EventLogPlug());
    }

    private void moduleInit(List<ModuleInitReceiver> moduleInitReceivers) {
        if (moduleInitReceivers == null) {
            return;
        }
        for (ModuleInitReceiver receiver : moduleInitReceivers) {
            receiver.init(context);
        }
    }

    @NonNull
    private ArrayList<ModuleInitReceiver> getModuleInitReceivers() {
        ArrayList<ModuleInitReceiver> receivers = new ArrayList<ModuleInitReceiver>();
        Bundle metaData = null;
        try {
            metaData = SplitBaseApp.context.getPackageManager().getApplicationInfo((String)SplitBaseApp.context.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (metaData != null) {
            for (String s : metaData.keySet()) {
                Object o = metaData.get(s);
                if (!"module_init".equals(o)) continue;
                try {
                    Class<?> aClass = Class.forName(s);
                    if (!ModuleInitReceiver.class.isAssignableFrom(aClass)) continue;
                    ModuleInitReceiver receiver = (ModuleInitReceiver)aClass.newInstance();
                    receivers.add(receiver);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return receivers;
    }

    public static Context getContext() {
        return context;
    }
}

