/*
 * Decompiled with CFR 0.152.
 */
package com.ldy.splitbase.base;

import android.support.annotation.NonNull;

public class ComparableWrapper<T>
implements Comparable<ComparableWrapper<T>> {
    private final int priority;
    private final T content;

    public ComparableWrapper(int priority, T content) {
        this.priority = priority;
        this.content = content;
    }

    public T getContent() {
        return this.content;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(@NonNull ComparableWrapper<T> o) {
        return this.priority - o.priority;
    }

    public static <T> ComparableWrapper<T> buildFirst(T content) {
        return new ComparableWrapper<T>(0, content);
    }

    public static <T> ComparableWrapper<T> buildSecond(T content) {
        return new ComparableWrapper<T>(1, content);
    }

    public static <T> ComparableWrapper<T> buildThird(T content) {
        return new ComparableWrapper<T>(2, content);
    }

    public static <T> ComparableWrapper<T> buildFourth(T content) {
        return new ComparableWrapper<T>(3, content);
    }

    public static <T> ComparableWrapper<T> buildFifth(T content) {
        return new ComparableWrapper<T>(4, content);
    }

    public static <T> ComparableWrapper<T> buildSixth(T content) {
        return new ComparableWrapper<T>(5, content);
    }

    public String toString() {
        return "ComparableWrapper{priority=" + this.priority + ", content=" + this.content + '}';
    }
}

