/*
 * Decompiled with CFR 0.152.
 */
package com.ldy.splitbase.config;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.ldy.splitbase.config.ConfigValue;
import com.ldy.splitbase.util.TransformUtil;
import java.security.InvalidParameterException;
import java.util.Arrays;

public class BaseConfig {
    @Nullable
    public static String getStrValue(Object ... objects) {
        Object value = BaseConfig.getValue(objects);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    @NonNull
    public static String getVerifyStrValue(Object ... objects) {
        return String.valueOf(BaseConfig.getVerifyValue(objects));
    }

    @Nullable
    public static Integer getIntegerValue(Object ... objects) {
        return TransformUtil.toInt(BaseConfig.getValue(objects));
    }

    public static int getVerifyIntValue(Object ... objects) {
        Integer integer = TransformUtil.toInt(BaseConfig.getVerifyValue(objects));
        if (integer == null) {
            throw new InvalidParameterException("\u53c2\u6570\u89e3\u6790\u7ed3\u679c\u4e0d\u4e3aint\u7c7b\u578b");
        }
        return integer;
    }

    @Nullable
    public static Float getFloatValue(Object ... objects) {
        return TransformUtil.toFloat(BaseConfig.getValue(objects));
    }

    public static float getVerifyFloatValue(Object ... objects) {
        Float aFloat = TransformUtil.toFloat(BaseConfig.getVerifyValue(objects));
        if (aFloat == null) {
            throw new InvalidParameterException("\u53c2\u6570\u89e3\u6790\u7ed3\u679c\u4e0d\u4e3afloat\u7c7b\u578b");
        }
        return aFloat.floatValue();
    }

    @NonNull
    public static Object getVerifyValue(Object ... objects) {
        if (objects == null) {
            throw new InvalidParameterException("param must not be null");
        }
        Object value = BaseConfig.getValue(objects);
        if (value == null) {
            throw new InvalidParameterException(Arrays.toString(objects) + ":\u89e3\u6790\u7ed3\u679c\u4e0d\u80fd\u4e3anull");
        }
        return value;
    }

    @Nullable
    public static Object getValue(Object ... objects) {
        if (objects == null) {
            return null;
        }
        Object result = null;
        for (Object object : objects) {
            if (object != null && (result = object instanceof ConfigValue ? ((ConfigValue)object).getValue() : object) != null) break;
        }
        return result;
    }
}

