/*
 * Decompiled with CFR 0.152.
 */
package com.ldy.splitbase.config;

import android.content.Context;
import android.support.annotation.Nullable;
import com.ldy.splitbase.SplitBaseApp;
import com.ldy.splitbase.config.ConfigValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertyValue
implements ConfigValue<String> {
    private final String key;
    public static final String CONFIG_FILE_NAME = "config.properties";
    private static Properties configProperties;

    public PropertyValue(String key) {
        this.key = key;
    }

    @Override
    @Nullable
    public String getValue() {
        return PropertyValue.getPropertyConfigValue(this.key);
    }

    @Nullable
    public static String getPropertyConfigValue(String key) {
        if (configProperties == null) {
            Context context = SplitBaseApp.getContext();
            try {
                InputStream inputStream = context.getAssets().open(CONFIG_FILE_NAME);
                configProperties = new Properties();
                configProperties.load(inputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (configProperties != null) {
            return configProperties.getProperty(key);
        }
        return null;
    }

    public String toString() {
        return "PropertyValue{key='" + this.key + '\'' + '}';
    }
}

