/*
 * Decompiled with CFR 0.152.
 */
package com.ldy.splitbase.config;

import android.content.Context;
import android.support.annotation.Nullable;
import com.ldy.splitbase.SplitBaseApp;
import com.ldy.splitbase.config.ConfigValue;

public class ResourceValue
implements ConfigValue<Integer> {
    private final String name;
    private final String defType;

    public ResourceValue(String name, String defType) {
        this.name = name;
        this.defType = defType;
    }

    @Override
    @Nullable
    public Integer getValue() {
        Context context = SplitBaseApp.getContext();
        if (context == null) {
            return null;
        }
        int identifier = context.getResources().getIdentifier(this.name, this.defType, context.getPackageName());
        if (identifier == 0) {
            return null;
        }
        return identifier;
    }

    public String toString() {
        return "ResourceValue{name='" + this.name + '\'' + ", defType='" + this.defType + '\'' + '}';
    }

    public static ResourceValue buildAnimResource(String name) {
        return new ResourceValue(name, "anim");
    }

    public static ResourceValue buildAttrResource(String name) {
        return new ResourceValue(name, "attr");
    }

    public static ResourceValue buildBoolResource(String name) {
        return new ResourceValue(name, "bool");
    }

    public static ResourceValue buildColorResource(String name) {
        return new ResourceValue(name, "color");
    }

    public static ResourceValue buildDimenResource(String name) {
        return new ResourceValue(name, "dimen");
    }

    public static ResourceValue buildDrawableResource(String name) {
        return new ResourceValue(name, "drawable");
    }

    public static ResourceValue buildIdResource(String name) {
        return new ResourceValue(name, "id");
    }

    public static ResourceValue buildIntegerResource(String name) {
        return new ResourceValue(name, "integer");
    }

    public static ResourceValue buildLayoutResource(String name) {
        return new ResourceValue(name, "layout");
    }

    public static ResourceValue buildStringResource(String name) {
        return new ResourceValue(name, "string");
    }

    public static ResourceValue buildStyleResource(String name) {
        return new ResourceValue(name, "style");
    }

    public static ResourceValue buildStyleableResource(String name) {
        return new ResourceValue(name, "styleable");
    }
}

