/*
 * Decompiled with CFR 0.152.
 */
package com.ldy.splitbase.modulecommunication.event;

import com.ldy.splitbase.modulecommunication.event.Event;
import com.ldy.splitbase.modulecommunication.event.plug.EventPlug;
import com.squareup.otto.Bus;
import java.util.ArrayList;
import java.util.List;

public class EventControl {
    private static final EventControl instance = new EventControl();
    private Bus eventBus = new Bus();
    private List<EventPlug> eventPlugs;

    public static EventControl instance() {
        return instance;
    }

    private EventControl() {
    }

    public void post(Event event) {
        if (!this.preEvent(event)) {
            this.eventBus.post((Object)event);
        }
        this.postEvent(event);
    }

    public void register(Object subscriber) {
        this.eventBus.register(subscriber);
    }

    public void unregister(Object subscriber) {
        this.eventBus.unregister(subscriber);
    }

    public void registerPlug(EventPlug eventPlug) {
        if (this.eventPlugs == null) {
            this.eventPlugs = new ArrayList<EventPlug>();
        }
        this.eventPlugs.add(eventPlug);
    }

    public void unRegisterPlug(EventPlug eventPlug) {
        if (this.eventPlugs != null && this.eventPlugs.contains(eventPlug)) {
            this.eventPlugs.remove(eventPlug);
        }
    }

    private boolean preEvent(Event event) {
        for (EventPlug eventPlug : this.eventPlugs) {
            if (!eventPlug.getEventClass().isAssignableFrom(event.getClass()) || !eventPlug.preEvent(event)) continue;
            return true;
        }
        return false;
    }

    private void postEvent(Event event) {
        for (EventPlug eventPlug : this.eventPlugs) {
            if (!eventPlug.getEventClass().isAssignableFrom(event.getClass())) continue;
            eventPlug.postEvent(event);
        }
    }
}

