/**
 * Copyright 2014 Jeroen Mols
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.jmolsmobile.landscapevideocapture.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ImageView.ScaleType;
import android.widget.MediaController;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.VideoView;

import com.xdja.eoa.vca.R;
import java.util.Timer;
import java.util.TimerTask;


public class VideoCaptureView extends FrameLayout implements OnClickListener, MediaPlayer.OnCompletionListener {
	private final static  String TAG = "VideoCaptureView";

	private TextView					mDeclineBtnIv;
	private TextView					mAcceptBtnIv;
	private ImageView					mRecordBtnIv;
	private SurfaceView					mSurfaceView;
	private VideoView 					mVideoView;
	private MediaController				mMediaController;
	private ImageView					mThumbnailIv;
	private ImageView					mPreviImgBtnIv;
	private TextView					mTimeTxt;
	private TextView					mRetake;//重拍
	private TextView					mExchangeBtnIv;//切换

	private RelativeLayout				mTopCoverLayout;
	private TextView					mSizeTv;//视频大小
	private TextView					mDurationTv;//视频长度


	// 刷新任务
	protected static Timer mTimer;
	protected static TimerTask mTimerTask;
	// 分时刷新频率 1000毫秒
	protected final static int mTimeRefresh =1000;
	// 异步任务
	protected Handler mHandler;
	// 回复字体颜色和背景颜色
	protected final static int BACK_TIME = 11002;
	//循环
	private static boolean isloop = true;
	//计时计算
	private static int num =0;

	private RecordingButtonInterface	mRecordingInterface;





	public VideoCaptureView(Context context) {
		super(context);
		initialize(context);

	}

	public VideoCaptureView(Context context, AttributeSet attrs) {
		super(context, attrs);
		initialize(context);
	}

	public VideoCaptureView(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);
		initialize(context);
	}

	private void initialize(Context context) {
		final View videoCapture = View.inflate(context, R.layout.view_videocapture, this);
		//录制的开始和停止
		mRecordBtnIv = videoCapture.findViewById(R.id.videocapture_recordbtn_iv);
		//发送
		mAcceptBtnIv = videoCapture.findViewById(R.id.videocapture_acceptbtn_iv);
		//取消
		mDeclineBtnIv = videoCapture.findViewById(R.id.videocapture_declinebtn_iv);
		//预览
		mPreviImgBtnIv = videoCapture.findViewById(R.id.videocapture_previImg_iv);
		//倒计时
		mTimeTxt = videoCapture.findViewById(R.id.videocapture_preview_tv);
		//切换
		mExchangeBtnIv= videoCapture.findViewById(R.id.videocapture_exchangebtn_iv);
		//重拍
		mRetake= videoCapture.findViewById(R.id.videocapture_retake_iv);

		mTopCoverLayout = videoCapture.findViewById(R.id.topCover_layout);
		mSizeTv = videoCapture.findViewById(R.id.size_tv);//摄制完毕后显示视频文件大小
		mDurationTv = videoCapture.findViewById(R.id.duration_tv);//摄制完毕后显示时长

		mRecordBtnIv.setOnClickListener(this);
		mAcceptBtnIv.setOnClickListener(this);
		mDeclineBtnIv.setOnClickListener(this);
		mPreviImgBtnIv.setOnClickListener(this);
		mExchangeBtnIv.setOnClickListener(this);//切换
		mRetake.setOnClickListener(this);
		mThumbnailIv = videoCapture.findViewById(R.id.videocapture_preview_iv);
		//视频播放
		mVideoView = videoCapture.findViewById(R.id.videocapture_previewVideo_iv);
		mMediaController = new MediaController(context);
		mVideoView.setMediaController(mMediaController);
		mMediaController.setMediaPlayer(mVideoView);
		mVideoView.setOnCompletionListener(this);
		mSurfaceView = videoCapture.findViewById(R.id.videocapture_preview_sv);
		mHandler = new Handler(){
			@Override
			public void handleMessage(Message msg) {
				handleMsg(msg);
			}
		};
	}

	public void setRecordingButtonInterface(RecordingButtonInterface mBtnInterface) {
		this.mRecordingInterface = mBtnInterface;
	}

	public SurfaceHolder getPreviewSurfaceHolder() {
		return mSurfaceView.getHolder();
	}

	public void hideSurfaceView() {
		mSurfaceView.setVisibility(View.GONE);
	}

	public void updateUINotRecording() {
		mRecordBtnIv.setSelected(false);
		mRecordBtnIv.setVisibility(View.VISIBLE);
		mAcceptBtnIv.setVisibility(View.GONE);
		mDeclineBtnIv.setVisibility(View.VISIBLE);
		mThumbnailIv.setVisibility(View.GONE);
		mPreviImgBtnIv.setVisibility(View.GONE);
		mVideoView.setVisibility(View.GONE);
		mSurfaceView.setVisibility(View.VISIBLE);
		mExchangeBtnIv.setVisibility(View.VISIBLE);
		mRetake.setVisibility(View.GONE);
		mTimeTxt.setVisibility(View.VISIBLE);
		mTimeTxt.setText("0/30s");
		//bengin add by renjw at 2015/12/4 14:42
		mTopCoverLayout.setVisibility(View.GONE);
		//end add by renjw at 2015/12/4 14:42
	}

	public void updateUIRecordingOngoing() {
		mRecordBtnIv.setSelected(true);
		mRecordBtnIv.setVisibility(View.VISIBLE);
		mAcceptBtnIv.setVisibility(View.GONE);
		mDeclineBtnIv.setVisibility(View.GONE);
		mThumbnailIv.setVisibility(View.GONE);
		mPreviImgBtnIv.setVisibility(View.GONE);
		mVideoView.setVisibility(View.GONE);
		mExchangeBtnIv.setVisibility(View.GONE);
		mRetake.setVisibility(View.GONE);
		mSurfaceView.setVisibility(View.VISIBLE);
	}

	public void updateUIRecordingFinished(Bitmap videoThumbnail) {
		Log.i("renjw","updateUIRecordingFinished");
		mRecordBtnIv.setVisibility(View.INVISIBLE);
		mAcceptBtnIv.setVisibility(View.VISIBLE);
		mDeclineBtnIv.setVisibility(View.VISIBLE);
		mThumbnailIv.setVisibility(View.VISIBLE);
		mRetake.setVisibility(View.VISIBLE);
		mPreviImgBtnIv.setVisibility(View.VISIBLE);
		mSurfaceView.setVisibility(View.GONE);
		mTimeTxt.setVisibility(View.GONE);
		mVideoView.setVisibility(View.GONE);
		mExchangeBtnIv.setVisibility(View.GONE);
		//bengin add by renjw at 2015/12/4 14:42
		mTopCoverLayout.setVisibility(View.VISIBLE);
		//end add by renjw at 2015/12/4 14:42
		final Bitmap thumbnail = videoThumbnail;
		if (thumbnail != null) {
			mThumbnailIv.setScaleType(ScaleType.FIT_CENTER);
			mThumbnailIv.setImageBitmap(videoThumbnail);
		}
	}

	public void updateUIVideoPreview(String filepath) {
		Log.i("renjw", "updateUIVideoPreview");
		mRecordBtnIv.setVisibility(View.INVISIBLE);
		mAcceptBtnIv.setVisibility(View.VISIBLE);
		mDeclineBtnIv.setVisibility(View.VISIBLE);
		mRetake.setVisibility(View.VISIBLE);
		mThumbnailIv.setVisibility(View.GONE);
		mPreviImgBtnIv.setVisibility(View.GONE);
		mSurfaceView.setVisibility(View.GONE);
		mTimeTxt.setVisibility(View.GONE);
		mVideoView.setVisibility(View.VISIBLE);
		mExchangeBtnIv.setVisibility(View.GONE);
		//bengin add by renjw at 2015/12/4 14:42
		mTopCoverLayout.setVisibility(View.GONE);
		//end add by renjw at 2015/12/4 14:42
		if (filepath!=null){
			Log.e(TAG,"文件路径======>"+filepath);
			mVideoView.setVideoPath(filepath);
			mVideoView.start();
		}

	}

	public void updateUIVideoPreviewFinish() {
		Log.i("renjw","updateUIVideoPreviewFinish");
		mRecordBtnIv.setVisibility(View.INVISIBLE);
		mAcceptBtnIv.setVisibility(View.VISIBLE);
		mDeclineBtnIv.setVisibility(View.VISIBLE);
		mThumbnailIv.setVisibility(View.VISIBLE);
		mPreviImgBtnIv.setVisibility(View.VISIBLE);
		mRetake.setVisibility(View.VISIBLE);
		mSurfaceView.setVisibility(View.GONE);
		mTimeTxt.setVisibility(View.GONE);
		mVideoView.setVisibility(View.GONE);
		mExchangeBtnIv.setVisibility(View.GONE);
		//bengin add by renjw at 2015/12/4 14:42
		mTopCoverLayout.setVisibility(View.VISIBLE);
		//end add by renjw at 2015/12/4 14:42

	}

	public void updateVideoSize(String sizeStr){
		mSizeTv.setText(sizeStr);
	}



	/**
	 * 背景恢复默认机制 TODO(这里用一句话描述这个方法的作用)
	 *
	 * @Title: startTimerTask 设定文件
	 * @return void 返回类型
	 * @author 牛丰产
	 * @date 2015年1月5日 下午11:15:24
	 * @维护人:
	 * @version V1.0
	 */
	public void startTimerTask() {
		mTimer = new Timer();
		isloop= true;
		num = 0;
		mTimerTask = new TimerTask() {
			@Override
			public void run() {
				Message msg = mHandler.obtainMessage(BACK_TIME);
				if (isloop){
					num++;
					if (num >= 30) {
						isloop = false;
					}
					msg.arg1 = num;
					msg.sendToTarget();
				}else {
					num = 0;
					Log.e("mTimerTask","倒计时错误===>");
				}
			}
		};
		mTimer.schedule(mTimerTask, mTimeRefresh+300, mTimeRefresh);
	}
	protected void handleMsg(Message msg){
		switch (msg.what) {
			case BACK_TIME:
				mTimeTxt.setText(msg.arg1+"/30s");
				mDurationTv.setText(msg.arg1+"s");
				break;
			default:
				break;
		}
	}

	public void stopTimer(){
		//关闭定时器
		if (mTimer!=null) {
			mTimer.cancel();
			mTimer = null;
		}
		if (mTimerTask!=null) {
			mTimerTask.cancel();
			mTimerTask = null;
		}
	}
	@Override
	public void onClick(View v) {
		if (mRecordingInterface == null) return;

		if (v.getId() == mRecordBtnIv.getId()) {//录制的开始和停止
			mRecordingInterface.onRecordButtonClicked();
		} else if (v.getId() == mAcceptBtnIv.getId()) {//发送
			mRecordingInterface.onAcceptButtonClicked();
		} else if (v.getId() == mDeclineBtnIv.getId()) {//取消
			mRecordingInterface.onDeclineButtonClicked();
		} else if (v.getId() == mPreviImgBtnIv.getId()) {//预览
			mRecordingInterface.onPreviewButtonClicked();
		} else if (v.getId() == mExchangeBtnIv.getId()) {//切换镜头
			mRecordingInterface.onExchangewButtonClicked();
		} else if (v.getId() == R.id.videocapture_retake_iv) {
			updateUINotRecording();
		}

	}

	@Override
	public void onCompletion(MediaPlayer mp) {
		updateUIVideoPreviewFinish();
	}
}
