package com.xdja.voice.bean;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by ldy on 2016/11/18.
 */

public class VoiceFileInfo implements Parcelable {
    private String filePath;
    private int voiceLength;

    public VoiceFileInfo(String filePath, int voiceLength) {
        this.filePath = filePath;
        this.voiceLength = voiceLength;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public int getVoiceLength() {
        return voiceLength;
    }

    public void setVoiceLength(int voiceLength) {
        this.voiceLength = voiceLength;
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.filePath);
        dest.writeInt(this.voiceLength);
    }

    protected VoiceFileInfo(Parcel in) {
        this.filePath = in.readString();
        this.voiceLength = in.readInt();
    }

    public static final Parcelable.Creator<VoiceFileInfo> CREATOR = new Parcelable.Creator<VoiceFileInfo>() {
        @Override
        public VoiceFileInfo createFromParcel(Parcel source) {
            return new VoiceFileInfo(source);
        }

        @Override
        public VoiceFileInfo[] newArray(int size) {
            return new VoiceFileInfo[size];
        }
    };
}
