package com.xdja.voice.play;


import java.util.ArrayList;
import java.util.List;

/**
 * created by flyou at2017/02/15
 *
 * VoicePlayButton播放管理类
 *
 * 管理View中注册监听器
 */
public class ViewSenSorStack {
    private static ViewSenSorStack instance;
    public static List<Integer> viewStack;

    private ViewSenSorStack() {
        viewStack = new ArrayList<>();
    }

    public static synchronized ViewSenSorStack getInstance() {
        if (instance == null) {
            instance = new ViewSenSorStack();
        }

        return instance;
    }

    /**
     * 向View栈中增加View
     *
     * @param viewHashCode 唯一标识
     */
    public void add(int viewHashCode) {
        viewStack.add(viewHashCode);
    }

    /**
     * 移除View栈中的View
     *
     * @param viewHashCode 唯一标识
     */
    public void remove(int viewHashCode) {
        for (int i = 0; i < viewStack.size(); i++) {
            if (viewStack.get(i) == viewHashCode) {
                viewStack.remove(i);
            }
        }
    }

    /**
     * 获取View栈中View的数量
     */
    public int getStackSize() {
        return viewStack.size();
    }
}