package com.xdja.voice.play;

import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.MediaPlayer.OnCompletionListener;

import com.xdja.voice.recordingControl.AudioFunctions;

import java.io.File;

public class VoiceMediaPlayer {
    public static final String ACTION_VOICE_PLAY_STATE = "action.voice.play.state";
    public static final String PLAY_MESSAGE_ID = "play_message_id";
    public static final String VOICE_PLAY_STATE = "voice_play_state";
    private MediaPlayer mMediaPlayer = null;
    public static boolean isPlaying = false;
    private static Context mContext = null;
    private static AudioManager audioManager;
    private static String playingMsgId = "";
    private String filePath="";

    private static VoiceMediaPlayer instance = null;

    private VoiceMediaPlayer(Context context) {
        mContext = context.getApplicationContext();
        audioManager = (AudioManager) mContext.getSystemService(Context.AUDIO_SERVICE);
    }

    public static VoiceMediaPlayer getInstance(Context context) {
        synchronized (VoiceMediaPlayer.class) {
            if (instance == null) {
                instance = new VoiceMediaPlayer(context);
            }
        }
        return instance;
    }


    public void start(String filePath){
        mMediaPlayer = new MediaPlayer();
        mMediaPlayer.setAudioStreamType(AudioManager.STREAM_MUSIC);
        this.filePath=filePath;
        mMediaPlayer.stop();
        mMediaPlayer.reset();
        sendPlayStateBroadcast(VoicePlayState.STOP);
        startPlay(filePath,true);
    }
    /**
     * 播放音频消息
     */
    private boolean startPlay(String filePath,boolean isNormal) {
        playingMsgId = filePath;
        if (!(new File(filePath).exists())) {
            return false;
        }
        if (mMediaPlayer==null){
            mMediaPlayer = new MediaPlayer();
        }
        if (isNormal) {
            audioManager.setMode(AudioManager.MODE_NORMAL);
            audioManager.setSpeakerphoneOn(true);
            mMediaPlayer.setAudioStreamType(AudioManager.STREAM_RING);
        } else {
            audioManager.setSpeakerphoneOn(false);
            audioManager.setMode(AudioManager.MODE_IN_COMMUNICATION);
            mMediaPlayer.setAudioStreamType(AudioManager.STREAM_VOICE_CALL);
        }

            try {

                mMediaPlayer.reset();
                mMediaPlayer.setDataSource(filePath);
                mMediaPlayer.prepare();
                mMediaPlayer.setOnCompletionListener(new OnCompletionListener() {
                    @Override
                    public void onCompletion(MediaPlayer mp) {
                        stopPlaying(VoicePlayState.COMPLETION);
                    }
                });

                mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener() {
                    @Override
                    public boolean onError(MediaPlayer mp, int what, int extra) {
                        stopPlaying(VoicePlayState.ERROR);
                        return false;
                    }
                });

                AudioFunctions.muteAudioFocus(mContext, true);
                mMediaPlayer.start();

                isPlaying = true;
                // 发送播放语音动画广播
                sendPlayStateBroadcast(VoicePlayState.PLAYING);
            } catch (Exception e) {
                e.printStackTrace();
                stopPlaying(VoicePlayState.ERROR);
            }


        return true;
    }

    /**
     * 停止播放
     */
    public void stopPlay() {
        stopPlaying(VoicePlayState.STOP);
    }

    /**
     * 发送播放语音状态的广播
     */
    public static void sendPlayStateBroadcast(VoicePlayState state) {
        if (mContext != null && !isBlank(playingMsgId)) {
            Intent intent = new Intent();
            intent.setAction(ACTION_VOICE_PLAY_STATE);
            intent.putExtra(PLAY_MESSAGE_ID, playingMsgId);
            intent.putExtra(VOICE_PLAY_STATE, state.getKey());
            mContext.sendBroadcast(intent);
        }
    }


    /**
     * 处理播放结束
     * <p/>
     * isCompletion 是否正常播放完毕
     *
     * @since 2014-4-14 下午9:40:59
     */
    private void stopPlaying(VoicePlayState state) {

        try {
            if (mMediaPlayer != null) {
                mMediaPlayer.stop();

            }
        } catch (IllegalStateException e){
            e.printStackTrace();
        }

        isPlaying = false;

            if (!isBlank(playingMsgId)) {
                sendPlayStateBroadcast(state);

                playingMsgId = "";
            }
    }

    /**
     * 停止播放所有
     */
    public void stopPlayAll() {
        try {
            if (mMediaPlayer != null) {
                mMediaPlayer.stop();
                mMediaPlayer.release();
                mMediaPlayer = null;
                sendPlayStateBroadcast(VoicePlayState.STOP);
            }
        } catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    /**
     * 当前消息是否在播放
     * @param messageId
     * @return
     */
    public static boolean getVoiceMessageIsPlaying(String messageId) {
        if (isBlank(messageId)) {
            return false;
        }

            return playingMsgId.equals(messageId);

    }

    /**
     * 正在播放的文件id
     * @return
     */
    public static String getPlayingMsgId() {

            return playingMsgId;

    }

    /**
     * 传感器状态
     * @param isNormal
     */
    public void sensorChanged(boolean isNormal) {
        if (isPlaying) {
            if (mMediaPlayer != null) {
                mMediaPlayer.stop();
                mMediaPlayer.reset();
            }
        }
        //停止当前播放的语音
        sendPlayStateBroadcast(VoicePlayState.STOP);
        startPlay(filePath,isNormal);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if(str != null && (strLen = str.length()) != 0) {
            for(int i = 0; i < strLen; ++i) {
                if(!Character.isWhitespace(str.charAt(i))) {
                    return false;
                }
            }

            return true;
        } else {
            return true;
        }
    }
}