package com.xdja.voice.play;

/**
 * Created by xrj on 2015/8/11.
 */
public enum VoicePlayState {
    DEFAULT(0, "默认类型"),

    PLAYING(1, "正在播放"),

    SUSPAUSE(2, "暂停播放"),

    STOP(3, "停止播放"),

    COMPLETION(4, "播放完成"),

    ERROR(5, "播放完成");

    private int key;

    private String description;

    VoicePlayState(int key, String description) {
        this.key = key;
        this.description = description;
    }

    public int getKey() {
        return key;
    }

    public String getDescription() {
        return description;
    }


    public static VoicePlayState getPlayState(int key){

        VoicePlayState voicePlayState = DEFAULT;

        for(VoicePlayState type : VoicePlayState.values()){

            if(type.getKey() == key){

                voicePlayState = type;

                break;
            }
        }
        return voicePlayState;
    }
}
