package com.xdja.voice.play;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;

import com.xdja.voice.recordingControl.AudioFunctions;

public class VoiceResMediaPlayer {

    private static VoiceResMediaPlayer instance = null;

    private MediaPlayer mMediaPlayer = null;
    private static boolean isPlaying = false;
    private static Context mContext = null;
    private static AudioManager audioManager;

    private VoiceResMediaPlayer(Context context) {
        mContext = context.getApplicationContext();
        audioManager = (AudioManager) mContext.getSystemService(Context.AUDIO_SERVICE);
    }

    public static VoiceResMediaPlayer getInstance(Context context) {
        synchronized (VoiceResMediaPlayer.class) {
            if (instance == null) {
                instance = new VoiceResMediaPlayer(context);
            }
        }
        return instance;
    }

    public void start(int voiceResId) {
        if (mMediaPlayer == null) {
            mMediaPlayer = new MediaPlayer();
        } else {
            stopPlaying();
        }
        startPlay(voiceResId, true);
    }

    /**
     * 播放音频消息
     */
    private boolean startPlay(int voiceResId, boolean isNormal) {
        if (isNormal) {
            audioManager.setMode(AudioManager.MODE_NORMAL);
            audioManager.setSpeakerphoneOn(true);
            mMediaPlayer.setAudioStreamType(AudioManager.STREAM_RING);
        } else {
            audioManager.setSpeakerphoneOn(false);
            audioManager.setMode(AudioManager.MODE_IN_COMMUNICATION);
            mMediaPlayer.setAudioStreamType(AudioManager.STREAM_VOICE_CALL);
        }

        try {
            mMediaPlayer.reset();
            AssetFileDescriptor file = mContext.getResources().openRawResourceFd(voiceResId);
            mMediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
            mMediaPlayer.prepare();
            file.close();
            mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener() {
                @Override
                public void onCompletion(MediaPlayer mp) {
                    stopPlaying();
                }
            });

            mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener() {
                @Override
                public boolean onError(MediaPlayer mp, int what, int extra) {
                    stopPlaying();
                    return false;
                }
            });

            AudioFunctions.muteAudioFocus(mContext, true);
            mMediaPlayer.start();
            isPlaying = true;
        } catch (Exception e) {
            e.printStackTrace();
            stopPlaying();
        }
        return true;
    }

    /**
     * 处理播放结束
     * <p/>
     * isCompletion 是否正常播放完毕
     *
     * @since 2014-4-14 下午9:40:59
     */
    private void stopPlaying() {
        try {
            if (mMediaPlayer != null) {
                mMediaPlayer.stop();
            }
        } catch (IllegalStateException e) {
            e.printStackTrace();
        }

        isPlaying = false;
    }
}
