package com.xdja.voice.recordingControl.manager;

import android.media.MediaRecorder;

import java.io.File;
import java.io.IOException;
import java.util.UUID;

public class AudioManager {
    private MediaRecorder mMediaRecorder;
    private String mDir;
    private String mCurrentFilePath;

    private boolean isPrepare;

    public AudioManager(String dir) {
        mDir = dir;
    }

    /**
     * 使用接口 用于回调
     */
    public interface AudioStateListener {
        void wellPrepared();

        void checkCurrentFocusView();

        void prepareFaild();
    }

    public AudioStateListener mAudioStateListener;

    /**
     * 回调方法
     */
    public void setOnAudioStateListener(AudioStateListener listener) {
        mAudioStateListener = listener;
    }

    // 去准备
    public synchronized void prepareAudio() {
        try {
            isPrepare = false;
            File dir = new File(mDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String fileName = generateFileName();
            File file = new File(dir, fileName);

            mCurrentFilePath = file.getAbsolutePath();

            release();

            mMediaRecorder = new MediaRecorder();
            // 设置输出文件
            mMediaRecorder.setOutputFile(file.getAbsolutePath());
            // 设置MediaRecorder的音频源为麦克风
            mMediaRecorder.setAudioSource(MediaRecorder.AudioSource.MIC);
            // 设置音频格式
            mMediaRecorder.setOutputFormat(MediaRecorder.OutputFormat.AMR_NB);
            // 设置音频编码
            mMediaRecorder.setAudioEncoder(MediaRecorder.AudioEncoder.AMR_NB);
            //设置最大录音时长
            mMediaRecorder.setMaxDuration(60000);

            long beginTime = System.currentTimeMillis();

            // 准备录音
            mMediaRecorder.prepare();

            mMediaRecorder.start();

            long endTime = System.currentTimeMillis();

            if ((endTime - beginTime) > 500) {
                mAudioStateListener.checkCurrentFocusView();
                if (mMediaRecorder!=null) {
                    mMediaRecorder.stop();
                    mMediaRecorder.reset();
                }

            }else {
                if (mAudioStateListener != null) {
                    mAudioStateListener.wellPrepared();
                }
                isPrepare = true;
            }

        } catch (IllegalStateException e) {
            e.printStackTrace();
            prepareFaild();
        } catch (IOException e) {
            e.printStackTrace();
            prepareFaild();
        } catch (Exception e) {
            e.printStackTrace();
            prepareFaild();
        } finally {
        }
    }

    private void prepareFaild() {
        isPrepare = false;
        release();
        if (mAudioStateListener != null) {
            mAudioStateListener.prepareFaild();
        }
    }

    /**
     * 随机生成文件的名称
     */
    private String generateFileName() {
        return UUID.randomUUID().toString() + ".amr";
    }


    //获得声音振幅大小
    public synchronized double getAmplitude() {
        try {
            if (isPrepare) {
                if (mMediaRecorder != null) {
                    return mMediaRecorder.getMaxAmplitude();
                }
            }
        } catch (Exception e) {
        }
        return 1;
    }

    /**
     * 释放资源
     */
    public synchronized void release() {
        try {
            if (mMediaRecorder != null) {
                mMediaRecorder.stop();
                mMediaRecorder.reset();
                mMediaRecorder.release();
                mMediaRecorder = null;
            }
        } catch (Exception e) {

        } finally {
            if (mMediaRecorder != null) {
                mMediaRecorder = null;
            }
        }

    }

    /**
     * 取消录音
     */
    public synchronized void cancel() {
        release();
        deleteFile();
    }

    public void deleteFile() {
        if (mCurrentFilePath != null) {
            File file = new File(mCurrentFilePath);
            file.delete();
            mCurrentFilePath = null;
        }
    }

    public String getCurrentFilePath() {

        return mCurrentFilePath;
    }
}
